#include "StdAfx.h"
#include "q2chwmImageManager.h"

Cq2chwmImageManager::Cq2chwmImageManager(int in_cache_size)
{
	m_in_cache_size = in_cache_size;
}

Cq2chwmImageManager::~Cq2chwmImageManager(void)
{
	Destroy();
}

void Cq2chwmImageManager::Destroy()
{
	// Cq2chwmImage
	POSITION pos;
	CString cstr_filename;
	void *vop_value;
	for (pos = m_cMapImage.GetStartPosition(); pos != NULL;) {
		m_cMapImage.GetNextAssoc(pos, cstr_filename, vop_value);
		Cq2chwmImage *pImage = (Cq2chwmImage*)vop_value;
		delete pImage;
	}
	m_cMapImage.RemoveAll();
}

Cq2chwmImage *Cq2chwmImageManager::Create(
	CString cstr_filename,
	int in_width,
	int in_height,
	HDC hDC)
{
	Cq2chwmImage *pImage;
	// LbV
	void *vop_value = 0;
	if (m_cMapImage.Lookup(cstr_filename, vop_value) == TRUE) {
		pImage = (Cq2chwmImage*)vop_value;
	} else {
		// LbVɂȂ΍쐬
		pImage = new Cq2chwmImage();
		if (pImage->Create(cstr_filename, in_width, in_height, hDC) != S_OK) {
			return NULL;
		}
		m_cMapImage.SetAt(cstr_filename, (void*)pImage);
	}

	return pImage;
}
