#pragma once

#include "YoString.h"

// define
#define APP_NAME		"q2chwm"
#define APP_VERSION		"0.0.11"
#define USERAGENT		"Monazilla/1.00 ("APP_NAME"/"APP_VERSION")"
#define TIMEOUT			30
#define RECV_BUFF		1024 * 16
#define LINE_BUFF		1024 * 4
#define LF				"\n"
#define CR				"\r"

// G[`
#define ERR_NONE					0
#define ERR_CANCELED				-1
#define ERR_HTTP_CONNECT			-100
#define ERR_HTTP_GET				-101
#define ERR_HTTP_RECV				-102
#define ERR_HTTP_NOTMODIFIED		-103
#define ERR_HTTP_LOCATION			-104
#define ERR_HTTP_ABONE				-105

#define ERR_FILE_OPEN				-200
#define ERR_FILE_FORMAT				-201
#define ERR_FILE_CONVERT			-202
#define ERR_FILE_WRITE				-203

#define ERR_CONF_BROWSER			-300

#define ERR_JBBS_BBS_NOT_FOUND		-501
#define ERR_JBBS_KEY_NOT_FOUND		-502
#define ERR_JBBS_THREAD_NOT_FOUND	-503
#define ERR_JBBS_STORAGE_IN			-504
#define ERR_JBBS_SYSTEM				-505

#define ERR_MESSAGE					-600
#define ERR_SUBJECT					-601
#define ERR_SEND					-602
#define ERR_SEND_COOKIE				-603

#define ERR_RETRY					-900
#define ERR_DOLIB_AUTH				-901
#define ERR_PARAM					-902
// [U[`EBhEbZ[W
// ʑJڌn
#define WM_USER_CANCEL				WM_APP + 1
#define WM_USER_BOARDCLICKED		WM_APP + 2
#define WM_USER_SUBJECTCLICKED		WM_APP + 3
#define WM_USER_BOOKMARKCLICKED		WM_APP + 4
#define WM_USER_CACHECLICKED		WM_APP + 5
#define WM_USER_VIEWBACK			WM_APP + 6
#define WM_USER_VIEWFORWARD			WM_APP + 7
#define WM_USER_CACHEIMAGECLICKED	WM_APP + 8

// Rg[n
#define WM_USER_TABCLICKED			WM_APP + 10

// n
#define WM_USER_OPENURL				WM_APP + 20
#define WM_USER_OPENBOOKMARK		WM_APP + 21
#define WM_USER_ADDBOOKMARK			WM_APP + 22
#define WM_USER_OPENCACHE			WM_APP + 23
#define WM_USER_SHOWSTATUSBAR		WM_APP + 24
#define WM_USER_SETSTATUS			WM_APP + 25
#define WM_USER_SHOWSEARCHBAR		WM_APP + 26
#define WM_USER_SHOWFIND2CHBAR		WM_APP + 27
#define WM_USER_EXECSEARCH			WM_APP + 28
#define WM_USER_OPENFIND2CH			WM_APP + 29
#define WM_USER_EXECFIND2CH			WM_APP + 30
#define WM_USER_POPUPMENU			WM_APP + 31
#define WM_USER_UPDATEBOOKMARK		WM_APP + 32
#define WM_USER_NEXTARTICLE			WM_APP + 33
#define WM_USER_SETPROGRESS			WM_APP + 34
#define WM_USER_DELETEDATFILE		WM_APP + 35
#define WM_USER_EXECJUMP			WM_APP + 36
#define WM_USER_SHOWJUMPBAR			WM_APP + 37
#define WM_USER_DELETEIMAGEFILE		WM_APP + 38
#define WM_USER_ADDBOOKMARKBOARD	WM_APP + 39
#define WM_USER_GETIMAGE			WM_APP + 40

// Cq2chwmMessageNXp
#define WM_USER_CUSTOM				WM_APP +100
class Cq2chwmMessage;

// fobO}N
#define PRINTLOG(fmt, ...) CYoObject::PrintLog(__LINE__, MSG_DEBUG, __FUNCTION__, fmt, __VA_ARGS__)

// \[gpl쐬}N
#define MAKESORTINT(a,b,c) (a * 100000000 + b * 10000 + c)

// 邳}N
#define BRIGHTNESS(r, g, b)	(0.299 * r + 0.587 * g + 0.114 * b)

// [eBeB֐Q
// CString̕ϊ@\g?
CString W(const char *chp_string);
CYoString A(const wchar_t *chp_string);
CYoString UrlToPath(const char *chp_url);
CYoString UrlToImagePath(const char *chp_url);
BOOL ExistFile(const char *chp_filename, ULONGLONG *ullp_length = NULL, FILETIME *stp_modify = NULL);
BOOL MakeDirectory(const char *chp_dir);
CYoString GetBaseName(const char *chp_filename);
BOOL CleanFileTime(const char *chp_filename);
void PostCustomMessage(HWND hWnd, Cq2chwmMessage *pMessage);
CYoString ConvertGmtTime(FILETIME *stp_modify);
void ErrorMessageBox(int in_err);
void ErrorMessageBox(const char *chp_err);
void MessageLoop(DWORD dw_msec = 100);
void HtmlToText(CYoString &str_src);
void RenameFile(const char *chp_filename_src, const char *chp_filename_dst);
BOOL RemoveFile(const char *chp_filename);
BOOL CopyDirectory(const char *chp_src, const char *chp_dst);
BOOL RemoveDirectory(const char *chp_dir);
BOOL StringToClipboard(const TCHAR *lpszText);
int Atoi(const char *chp_num);
CYoString ConvertZenkaku(int in_num);
void ChangeSip(HWND hWnd, DWORD dwCode);
void SipOff(HWND hWnd);
void SipOn(HWND hWnd);
BOOL GetClipBoardText(HWND hWnd, CString &cstr_text);
const wchar_t *GetId(wchar_t *lpszId, DWORD *lpdwSize, const wchar_t* lpszText);
const wchar_t *GetRefer(wchar_t *lpszNumber, DWORD *lpdwSize, const wchar_t *lpszText);
const wchar_t *GetNumber(wchar_t *lpszNumber, DWORD *lpdwSize, const wchar_t *lpszText);
const wchar_t *GetLink(wchar_t *lpszLink, DWORD *lpdwSize, const wchar_t *lpszText);
void ReplaceMenu(CMenu *pMenu, BOOL bo_number);
