#include "StdAfx.h"

#include <winsock2.h>
#include "VentUtil.h"
#include "ServiceFunc.h"

/* Defines */
#define AUTOCONNECT_FEATURE
#define	VENTSM_PREFIX				_T("VSM")
#define VENTSM_FILENAME				(VENTSM_PREFIX _T("0:"))
#define VENTSM_DEVICEKEY			_T("VentSM")
#define VENTSM_SVC_REG_KEY			_T("Services\\VentSM")
#define VENTSM_SVC_REG_PREFIX		_T("Prefix")

#define VENTCONF_REG_KEY			_T("Software\\Venturi\\Venturi Configurator")
#define VENTCONF_REG_DBPORT			_T("DBPORT")
#define VENTCONF_DEFAULT_DBPORT		8975
//#define QUERY_PROFILE_STR			"GET rowid,vpn_prof,nr_profiles\nFROM VSLookupParams\n"
#define QUERY_PROFILE_STR			"GET vpn_prof,nr_profiles\nFROM VSLookupParams\n"
#define SET_PROFILE_STR				"SET vpn_prof=%d\nWHERE rowid=%d\nFROM VSLookupParams\n"
//#define QUERY_METATABLE_STR		"GET rowid,tablename,dbname,cols,rows,modified\nFROM MetaTable\n"
#define QUERY_METATABLE_STR			"GET rowid,tablename\nFROM MetaTable\n"
#define SET_METATABLE_STR			"SET modified=%d\nWHERE rowid=%d\nFROM MetaTable\n"

#define QUERY_SEND_TIMEOUT			(4*1000)
#define QUERY_RECV_TIMEOUT			(8*1000)
#define QUERY_METATABLE_BUFSIZ		(8*1024)
#define QUERY_STATUS_TOKEN			"status"
#define VSLOOKUPPARAMS_TOKEN		"VSLookupParams"

/* Global Variables */
static BOOL	gs_bInitialized = FALSE;

////////////////////////////////////////////////////////////////////


static
SOCKET
OpenDBConnection()
{
	HKEY	hKey = NULL;
	LONG	lResult;
	DWORD	dwDbPort = VENTCONF_DEFAULT_DBPORT;
	SOCKET	s;
	SOCKET	sRet;

	sRet = INVALID_SOCKET;

	lResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE, VENTCONF_REG_KEY, 0, NULL, &hKey);
	if (lResult == ERROR_SUCCESS) {
		DWORD	dwType;
		DWORD	dwSize;

		dwType = REG_DWORD;
		dwSize = sizeof(dwDbPort);

		RegQueryValueEx(hKey, VENTCONF_REG_DBPORT, NULL, &dwType, (LPBYTE)&dwDbPort, &dwSize);
		RegCloseKey(hKey);
		hKey = NULL;
	}

	s = socket(AF_INET, SOCK_STREAM, 0);
	if (s != INVALID_SOCKET) {
		struct sockaddr_in	servAddr;

		memset(&servAddr, 0, sizeof(servAddr));
		servAddr.sin_family			= AF_INET;
		servAddr.sin_addr.s_addr	= inet_addr("127.0.0.1");
		servAddr.sin_port			= htons((USHORT)dwDbPort);

		if (connect(s, (struct sockaddr*)&servAddr, sizeof(servAddr)) == 0) {
			sRet = s;
		}
		else {
			closesocket(s);
		}
	}

	return sRet;
}

static
BOOL
CloseDBConnection(
	SOCKET	s
)
{
	BOOL	bRet;

	bRet = FALSE;

	if (s != INVALID_SOCKET) {
		shutdown(s, SD_BOTH);
		closesocket(s);

		bRet = TRUE;
	}

	return bRet;
}

static
BOOL
SendRequest(
	SOCKET	s,
	LPBYTE	pBuf,
	DWORD	dwBufSize,
	DWORD	dwTimeout
)
{
	BOOL	bRet;
	LPBYTE	pPos;
	DWORD	dwRestSize;
	DWORD	dwStartTick;

	bRet = FALSE;

	if (s == INVALID_SOCKET) {
		return FALSE;
	}

	dwRestSize	= dwBufSize;
	pPos		= pBuf;
	dwStartTick	= GetTickCount();

	while(dwRestSize > 0) {
		int				iSel;
		DWORD			dwTime;
		struct timeval	timeout;
		fd_set			wfds;

		dwTime = GetTickCount() - dwStartTick;
		if (dwTime >= dwTimeout) {
			break;
		}
		dwTime = dwTimeout - dwTime;

		timeout.tv_sec	= dwTime/1000;
		timeout.tv_usec	= (dwTime%1000)*1000;

		FD_ZERO(&wfds);
		FD_SET(s, &wfds);
		iSel = select(s + 1, NULL, &wfds, NULL, &timeout);
		if (iSel > 0) {
			int	iSend;

			iSend = send(s, (char*)pPos, dwRestSize, 0);
			if (iSend > 0) {
				dwRestSize -= iSend;
				pPos += iSend;
				if (dwRestSize == 0) {
					bRet = TRUE;
					break;
				}
			}
			else {
				break;
			}
		}
		else if(iSel == 0) {
			;
		}
		else {
			break;
		}

	}

	return bRet;
}

static
BOOL
RecvResponse(
	SOCKET	s,
	LPBYTE	pBuf,
	DWORD	dwBufSize,
	DWORD	dwTimeout
)
{
	BOOL	bRet;
	LPBYTE	pPos;
	DWORD	dwRestSize;
	DWORD	dwStartTick;

	bRet = FALSE;

	if (s == INVALID_SOCKET) {
		return FALSE;
	}

	dwRestSize	= dwBufSize;
	pPos		= pBuf;
	dwStartTick	= GetTickCount();

	while(dwRestSize > 0) {
		int				iSel;
		DWORD			dwTime;
		struct timeval	timeout;
		fd_set			rfds;

		dwTime = GetTickCount() - dwStartTick;
		if (dwTime >= dwTimeout) {
			break;
		}
		dwTime = dwTimeout - dwTime;

		timeout.tv_sec	= dwTime/1000;
		timeout.tv_usec	= (dwTime%1000)*1000;

		FD_ZERO(&rfds);
		FD_SET(s, &rfds);
		iSel = select(s + 1, &rfds, NULL, NULL, &timeout);
		if (iSel > 0) {
			int	iRecv;

			iRecv = recv(s, (char*)pPos, dwRestSize, 0);
			if (iRecv > 0) {
				dwRestSize -= iRecv;
				pPos += iRecv;

				// \n\nŏIĂ邩̊mF
				if ( (pPos - pBuf) >= 2 &&
					(*((char*)pPos - 1) == '\n') &&
					(*((char*)pPos - 2) == '\n')) {

					bRet = TRUE;
					break;
				}
				//
			}
			else if (iRecv == 0) {
				bRet = TRUE;
				break;
			}
			else {
				break;
			}
		}
		else if (iSel == 0) {
			;
		}
		else {
			break;
		}


	}

	return bRet;
}

static
char*
ParseOneLine(
	char*	pBuf
)
{
	char*	p;
	char*	pNext;

	pNext = NULL;
	if (pBuf != NULL) {
		p = strchr(pBuf, '\n');
		if (p != NULL) {
			*p = '\0';
			pNext = p + 1;
		}
	}

	return pNext;
}

static
char*
ParseOneItem(
	char*	pLine
)
{
	char*	p;
	char*	pNext;

	pNext = NULL;
	if (pLine != NULL) {
		p = strchr(pLine, '\t');
		if (p != NULL) {
			*p = '\0';
			pNext = p + 1;
		}
	}

	return pNext;
}

static
BOOL
ParseStatusCode(
	char*	pLine,		// IN
	int*	pnStatus	// OUT
)
{
	BOOL	bRet;
	char*	p			= NULL;
	char*	pStatusStr	= NULL;

	bRet = FALSE;

	if (pLine != NULL && pnStatus != NULL) {
		p = strstr(pLine, QUERY_STATUS_TOKEN);
		if (p != NULL) {
			p += strlen(QUERY_STATUS_TOKEN);

			while (*p != '\0') {
				if (*p != ' ' && *p != '\t') {
					pStatusStr = p;
					break;
				}
				p++;
			}
			while (*p != '\0') {
				if (*p == ' ' || *p == '\t') {
					*p = '\0';
					break;
				}
				p++;
			}

			if (pStatusStr != NULL) {
				*pnStatus = atoi(pStatusStr);
				bRet = TRUE;
			}
		}
	}

	return bRet;
}


static
BOOL
ParseGetProfileResponse(
	char*	szBuf,
	int*	pnProf,
	int*	pnNumProf
)
{
	BOOL	bRet;
	char*	p			= NULL;
	char*	pNextLine	= NULL;
	char*	pNextItem	= NULL;
	int		iStatus		= 0;
	int		iProf		= 0;
	int		iNumProf	= 0;

	bRet = FALSE;

	if (szBuf == NULL || pnProf == NULL || pnNumProf == NULL) {
		return FALSE;
	}

	p = szBuf;
	pNextLine = ParseOneLine(p);
	if (pNextLine != NULL) {
		if (ParseStatusCode(p, &iStatus)) {
			if (iStatus == 0) {	// StatusCode000
				p = pNextLine;
				pNextLine = ParseOneLine(p);
				if (pNextLine != NULL) {

					pNextItem = ParseOneItem(p);
					if (pNextItem != NULL) {
						iProf = atoi(p);

						p = pNextItem;
						pNextItem = ParseOneItem(p);
						if (pNextItem != NULL) {
							iNumProf = atoi(p);

							*pnProf		= iProf;
							*pnNumProf	= iNumProf;

							bRet = TRUE;
						}
					}
				}
			}
		}
	}

	return bRet;
}

static
BOOL
ParseGetMetaTableResponse(
	char*	szBuf,		// IN
	int*	pnRowId		// OUT
)
{
	BOOL	bRet;
	char*	p			= NULL;
	char*	pNextLine	= NULL;
	char*	pNextItem	= NULL;
	int		iStatus		= 0;
	int		iRowId		= 0;

	bRet = FALSE;

	if (szBuf == NULL || pnRowId == NULL) {
		return FALSE;
	}

	p = szBuf;
	pNextLine = ParseOneLine(p);
	if (pNextLine != NULL) {
		if (ParseStatusCode(p, &iStatus)) {
			if (iStatus == 0) {	// StatusCode000

				while (pNextLine != NULL) {
					p = pNextLine;
					pNextLine = ParseOneLine(p);

					if (pNextLine != NULL) {

						pNextItem = ParseOneItem(p);
						if (pNextItem != NULL) {
							iRowId = atoi(p);

							p = pNextItem;
							pNextItem = ParseOneItem(p);
							if (pNextItem != NULL) {
								if (strcmp(p, VSLOOKUPPARAMS_TOKEN) == 0) {
									*pnRowId = iRowId;
									bRet = TRUE;
									break;
								}
							}
						}
					}
					else {
						break;
					}
				}
			}
		}
	}

	return bRet;
}

// VSLookupParamsɃANZXvpn_profȂǂ̒l擾
static
BOOL
VenturiGetProfile(
	int*	pnProf,
	int*	pnNumProf
)
{
	BOOL	bRet;
	SOCKET	s;
	char	szBuf[128];

	bRet = FALSE;

	if (pnProf == NULL || pnNumProf == NULL) {
		return FALSE;
	}

	s = OpenDBConnection();
	if (s != INVALID_SOCKET) {
		if (SendRequest(s, (unsigned char*)QUERY_PROFILE_STR, strlen(QUERY_PROFILE_STR), QUERY_SEND_TIMEOUT)) {
			memset(szBuf, 0, sizeof(szBuf));

			if (RecvResponse(s, (unsigned char*)szBuf, sizeof(szBuf)-1, QUERY_RECV_TIMEOUT)) {
				int	iProf		= 0;
				int	iNumProf	= 0;

				if (ParseGetProfileResponse(szBuf, &iProf, &iNumProf)) {
					*pnProf = iProf;
					*pnNumProf = iNumProf;

					bRet = TRUE;
				}
			}
		}

		CloseDBConnection(s);
	}

	return bRet;
}

// VSLookupParamsɃANZXvpn_prof̒lύX
static
BOOL
VenturiSetProfile(
	int		nProf
)
{
	BOOL	bRet;
	SOCKET	s;
	char	szSendBuf[128];
	char	szRecvBuf[128];

	bRet = FALSE;

	s = OpenDBConnection();
	if (s != INVALID_SOCKET) {
		sprintf(szSendBuf,
				SET_PROFILE_STR,
				nProf,				// Profile No.
				0					// rowid
				);
		if (SendRequest(s, (unsigned char*)szSendBuf, strlen(szSendBuf), QUERY_SEND_TIMEOUT)) {
			memset(szRecvBuf, 0, sizeof(szRecvBuf));

			if (RecvResponse(s, (unsigned char*)szRecvBuf, sizeof(szRecvBuf)-1, QUERY_RECV_TIMEOUT)) {
				bRet = TRUE;
			}
		}

		CloseDBConnection(s);
	}

	return bRet;
}


// MetaTableɃANZXVSLookupParamse[urowid擾
static
BOOL
VenturiGetRowIdFromMetaTable(
	int*	pnRowId
)
{
	BOOL	bRet;
	SOCKET	s;
	LPBYTE	pBuf;

	bRet = FALSE;

	if (pnRowId == NULL) {
		return FALSE;
	}

	pBuf = new BYTE[QUERY_METATABLE_BUFSIZ];

	if (pBuf != NULL) {

		s = OpenDBConnection();
		if (s != INVALID_SOCKET) {
			if (SendRequest(s, (unsigned char*)QUERY_METATABLE_STR, strlen(QUERY_METATABLE_STR), QUERY_SEND_TIMEOUT)) {
				memset(pBuf, 0, QUERY_METATABLE_BUFSIZ);

				if (RecvResponse(s, (unsigned char*)pBuf, QUERY_METATABLE_BUFSIZ-1, QUERY_RECV_TIMEOUT)) {
					int	iRowId = 0;

					if (ParseGetMetaTableResponse((char*)pBuf, &iRowId)) {

						*pnRowId = iRowId;
						bRet = TRUE;
					}
				}
			}

			CloseDBConnection(s);
		}

		delete [] pBuf;
	}

	return bRet;
}


// MetaTableɃANZXVSLookupParamsmodified1ɃZbg
static
BOOL
VenturiSetModifiedToMetaTable(
	int		nRowId
)
{
	BOOL	bRet;
	BOOL	bRecvResponse;
	SOCKET	s;
	char	szSendBuf[128];
	char	szRecvBuf[128];

	bRet = FALSE;

	s = OpenDBConnection();
	if (s != INVALID_SOCKET) {
		sprintf(szSendBuf,
				SET_METATABLE_STR,
				1,					// modified=1
				nRowId				// rowid
				);
		if (SendRequest(s, (unsigned char*)szSendBuf, strlen(szSendBuf), QUERY_SEND_TIMEOUT)) {
			memset(szRecvBuf, 0, sizeof(szRecvBuf));

			bRecvResponse = RecvResponse(s, (unsigned char*)szRecvBuf, sizeof(szRecvBuf)-1, QUERY_RECV_TIMEOUT);

#ifndef AUTOCONNECT_FEATURE
			if (bRecvResponse) {
				bRet = TRUE;
			}
#else
			// AutoConnectgp̓_CAAbvC
			// Response^CAEg邽ߐƂ
			bRet = TRUE;
#endif
		}

		CloseDBConnection(s);
	}

	return bRet;
}


static
BOOL
VenturiChangeAndCommitProfile(
	int	iProf	// IN
)
{
	BOOL	bRet;
	int		iRowId = 0;

	bRet = FALSE;

	if(VenturiGetRowIdFromMetaTable(&iRowId)) {
		if (VenturiSetProfile(iProf)) {
			if (VenturiSetModifiedToMetaTable(iRowId)) {
				bRet = TRUE;
			}
		}
	}

	return bRet;
}

// Venturi Utility̏
BOOL
VentUtil_Initialize()
{
	BOOL	bRet = FALSE;
	WORD	wVersion;
	WSADATA	wsaData;

	if (!gs_bInitialized) {

		// ServicenAPI
		if (SF_Init()) {

			// Winsock
			wVersion = MAKEWORD(1,1);
			if (WSAStartup(wVersion, &wsaData) == 0) {
				gs_bInitialized = TRUE;
				bRet = TRUE;
			}
			else {
				SF_Term();
			}
		}
	}

	return bRet;
}

// Venturi Utility̌n
BOOL
VentUtil_Terminate()
{
	BOOL	bRet = FALSE;

	if (gs_bInitialized) {
		
		WSACleanup();	// Winsockn
		SF_Term();		// ServicenAPIn

		gs_bInitialized = FALSE;
		bRet = TRUE;
	}

	return bRet;
}

// Venturi ClientCXg[Ă邩H
BOOL
VentUtil_IsInstalled()
{
	BOOL	bRet;
	HKEY	hKey = NULL;
	LONG	lResult;

	bRet = FALSE;

	lResult = RegOpenKeyEx(HKEY_LOCAL_MACHINE, VENTSM_SVC_REG_KEY, 0, 0, &hKey);
	if (lResult == ERROR_SUCCESS) {
		DWORD	dwType;
		DWORD	dwSize;
		TCHAR	szPrefix[16];

		memset(szPrefix, 0, sizeof(szPrefix));
		dwType = REG_SZ;
		dwSize = sizeof(szPrefix);

		lResult = RegQueryValueEx(hKey, VENTSM_SVC_REG_PREFIX, NULL, &dwType, (LPBYTE)szPrefix, &dwSize);
		if (lResult == ERROR_SUCCESS) {
			if (_tcscmp(szPrefix, VENTSM_PREFIX) == 0) {
				bRet = TRUE;
			}
		}

		RegCloseKey(hKey);
		hKey = NULL;
	}

	return bRet;
}

// Venturi Service Manager삵Ă邩H
BOOL
VentUtil_IsServiceStarted()
{
	BOOL	bRet;
	HANDLE	hService;

	bRet = FALSE;

	hService = SF_GetServiceHandle(VENTSM_FILENAME, NULL, 0);
	if (hService != INVALID_HANDLE_VALUE) {
		bRet = TRUE;
	}

	return bRet;
}

// Venturi Clientɂ鍂ONH
BOOL
VentUtil_IsEnable()
{
	BOOL	bRet		= FALSE;
	int		iProf		= 0;
	int		iNumProf	= 0;

	if (VenturiGetProfile(&iProf, &iNumProf)) {
		if (iProf == 0) {
			// Profile0Ȃ΁CݍON
			bRet = TRUE;
		}
	}

	return bRet;
}

// ON/OFF̐
BOOL
VentUtil_DoEnable(
	BOOL	bEnable
)
{
	BOOL	bRet = FALSE;
	int		iProfile;

	if (bEnable) {
		// ONɂȂCProfile0֕ύX
		iProfile = 0;
	}
	else {
		// OFFɂȂCProfile1֕ύX
		iProfile = 1;
	}

	bRet = VenturiChangeAndCommitProfile(iProfile);

	return bRet;
}
