#include "StdAfx.h"
#include "q2chwmImage.h"

#ifdef _WIN32_WCE
#include <initguid.h>
#include <imgguids.h>
#endif

Cq2chwmImage::Cq2chwmImage(void)
{
	m_hBitmap = NULL;
#ifdef _WIN32_WCE
#else
	m_pImage = NULL;
#endif
}

Cq2chwmImage::~Cq2chwmImage(void)
{
	Destroy();
}

void Cq2chwmImage::Destroy()
{
	m_sizeBitmap.cx = 0;
	m_sizeBitmap.cy = 0;
	if (m_hBitmap != NULL) {
		::DeleteObject(m_hBitmap);
		m_hBitmap = NULL;
	}
#ifdef _WIN32_WCE
#else
	if (m_pImage != NULL) {
		delete m_pImage;
		m_pImage = NULL;
	}
#endif
}

/*!
 * \brief
 * t@Cǂݍ.
 * 
 * \param cstr_filename
 * 摜t@C.
 * 
 * \returns
 * IS_OKAُÎƂS_OKȊOԂ.
 * 
 * 摜TCY̓IWiTCŶ܂.
 */
HRESULT Cq2chwmImage::Create(
	CString cstr_filename,
	HDC hCompatibleDC)
{
	Destroy();
	HRESULT hr = S_OK;
#ifdef _WIN32_WCE
	IImage *pImage = NULL;
	IImagingFactory *pImageFactory = NULL;
	ImageInfo info;
	CDC cMemoryDC;
	HGDIOBJ hOldBitmap;

	// Rp`uȃfoCXReLXg
	HDC hDC;
	CWindowDC *pWindowDC = NULL;
	if (hCompatibleDC == NULL) {
		pWindowDC = new CWindowDC(AfxGetMainWnd());
		hDC = pWindowDC->GetSafeHdc();
	} else {
		hDC = hCompatibleDC;
	}

	// COM
	::CoInitializeEx(NULL, COINIT_MULTITHREADED);

	// IImagingFactory쐬
	hr = CoCreateInstance(CLSID_ImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IImagingFactory, (void **)&pImageFactory);
	if (hr != S_OK) {
		goto end;
	}

	// IImage쐬
	hr = pImageFactory->CreateImageFromFile(cstr_filename, &pImage);
	if (hr != S_OK) {
		goto end;
	}

	// 摜TCY擾
	hr = pImage->GetImageInfo(&info);
	if (hr != S_OK) {
		goto end;
	}

	// k摜TCYvZ
	m_sizeBitmap.cx = info.Width;
	m_sizeBitmap.cy = info.Height;

	m_hBitmap = ::CreateCompatibleBitmap(hDC, m_sizeBitmap.cx, m_sizeBitmap.cy);
	cMemoryDC.CreateCompatibleDC(CDC::FromHandle(hDC));
	hOldBitmap = cMemoryDC.SelectObject(m_hBitmap);
	hr = pImage->Draw(cMemoryDC.GetSafeHdc(), CRect(0, 0, m_sizeBitmap.cx, m_sizeBitmap.cy), NULL);
	if (hr != S_OK) {
		cMemoryDC.SelectObject(hOldBitmap);
		cMemoryDC.DeleteDC();
		::DeleteObject(m_hBitmap);
		m_hBitmap = NULL;
		m_sizeBitmap.cx = 0;
		m_sizeBitmap.cy = 0;
		goto end;
	}
	cMemoryDC.SelectObject(hOldBitmap);
	cMemoryDC.DeleteDC();

end:
	if (pImage != NULL) pImage->Release();
	if (pImageFactory != NULL) pImageFactory->Release();
	::CoUninitialize();
	if (pWindowDC != NULL) delete pWindowDC;
	return hr;

#else
	CImage cImage;
	hr = cImage.Load(cstr_filename);
	if (hr != S_OK) {
		goto error;
	}

	// k摜TCYvZ
	m_sizeBitmap.cx = cImage.GetWidth();
	m_sizeBitmap.cy = cImage.GetHeight();
	m_pImage = new CImage();
	if (m_pImage->Create(m_sizeBitmap.cx, m_sizeBitmap.cy, 24) == FALSE) {
		hr = S_FALSE;
		goto error;
	}

	HDC hImageDC = m_pImage->GetDC();
	::SetStretchBltMode(hImageDC, HALFTONE);
	if (cImage.Draw(hImageDC, 0, 0, m_sizeBitmap.cx, m_sizeBitmap.cy, 0, 0, cImage.GetWidth(), cImage.GetHeight()) == FALSE) {
		hr = S_FALSE;
		goto error;
	}

	m_pImage->ReleaseDC();
	m_hBitmap = *m_pImage;
	return S_OK;

error:
	m_sizeBitmap.cx = 0;
	m_sizeBitmap.cy = 0;
	if (m_pImage != NULL) {
		delete m_pImage;
		m_pImage = NULL;
	}
	return hr;
#endif
}

/*!
 * \brief
 * t@Cǂݍ݁ATlC摜𐶐.
 * 
 * \param cstr_filename
 * 摜t@C.
 * 
 * \param in_width
 * qgTCY(̃TCYɎ܂悤ɏk).
 * 
 * \param in_height
 * qgTCY(̃TCYɎ܂悤ɏk).
 * 
 * \returns
 * IS_OKAُÎƂS_OKȊOԂ.
 * 
 */
HRESULT Cq2chwmImage::Create(
	CString cstr_filename,
	int in_width,
	int in_height,
	HDC hCompatibleDC)
{
	Destroy();
#ifdef _WIN32_WCE
	HRESULT hr = S_OK;
	IImage *pImage = NULL;
	IImage *pThumbnailImage = NULL;
	IImagingFactory *pImageFactory = NULL;
	ImageInfo info;
	CDC cMemoryDC;
	HGDIOBJ hOldBitmap;

	// Rp`uȃfoCXReLXg
	HDC hDC;
	CWindowDC *pWindowDC = NULL;
	if (hCompatibleDC == NULL) {
		pWindowDC = new CWindowDC(AfxGetMainWnd());
		hDC = pWindowDC->GetSafeHdc();
	} else {
		hDC = hCompatibleDC;
	}

	// COM
	::CoInitializeEx(NULL, COINIT_MULTITHREADED);

	// IImagingFactory쐬
	hr = CoCreateInstance(CLSID_ImagingFactory, NULL, CLSCTX_INPROC_SERVER, IID_IImagingFactory, (void **)&pImageFactory);
	if (hr != S_OK) {
		goto end;
	}

	// IImage쐬
	hr = pImageFactory->CreateImageFromFile(cstr_filename, &pImage);
	if (hr != S_OK) {
		goto end;
	}

	// 摜TCY擾
	hr = pImage->GetImageInfo(&info);
	if (hr != S_OK) {
		goto end;
	}

	// k摜TCYvZ
	m_sizeBitmap = getAdjustSize(CSize(info.Width, info.Height), CSize(in_width, in_height));

	// TlC摜쐬
	hr = pImage->GetThumbnail(m_sizeBitmap.cx, m_sizeBitmap.cy, &pThumbnailImage);
	if (hr != S_OK) {
		m_sizeBitmap.cx = 0;
		m_sizeBitmap.cy = 0;
		goto end;
	}

	m_hBitmap = ::CreateCompatibleBitmap(hDC, m_sizeBitmap.cx, m_sizeBitmap.cy);
	cMemoryDC.CreateCompatibleDC(CDC::FromHandle(hDC));
	hOldBitmap = cMemoryDC.SelectObject(m_hBitmap);
	hr = pThumbnailImage->Draw(cMemoryDC.GetSafeHdc(), CRect(0, 0, m_sizeBitmap.cx, m_sizeBitmap.cy), NULL);
	if (hr != S_OK) {
		cMemoryDC.SelectObject(hOldBitmap);
		cMemoryDC.DeleteDC();
		::DeleteObject(m_hBitmap);
		m_hBitmap = NULL;
		m_sizeBitmap.cx = 0;
		m_sizeBitmap.cy = 0;
		goto end;
	}
	cMemoryDC.SelectObject(hOldBitmap);
	cMemoryDC.DeleteDC();

end:
	if (pThumbnailImage != NULL) pThumbnailImage->Release();
	if (pImage != NULL) pImage->Release();
	if (pImageFactory != NULL) pImageFactory->Release();
	::CoUninitialize();
	if (pWindowDC != NULL) delete pWindowDC;
	return hr;

#else
	HRESULT hr = S_OK;
	CImage cImage;
	hr = cImage.Load(cstr_filename);
	if (hr != S_OK) {
		goto error;
	}

	// k摜TCYvZ
	m_sizeBitmap = getAdjustSize(CSize(cImage.GetWidth(), cImage.GetHeight()), CSize(in_width, in_height));
	m_pImage = new CImage();
	if (m_pImage->Create(m_sizeBitmap.cx, m_sizeBitmap.cy, 24) == FALSE) {
		hr = S_FALSE;
		goto error;
	}

	HDC hImageDC = m_pImage->GetDC();
	::SetStretchBltMode(hImageDC, HALFTONE);
	if (cImage.Draw(hImageDC, 0, 0, m_sizeBitmap.cx, m_sizeBitmap.cy, 0, 0, cImage.GetWidth(), cImage.GetHeight()) == FALSE) {
		hr = S_FALSE;
		goto error;
	}

	m_pImage->ReleaseDC();
	m_hBitmap = *m_pImage;
	return S_OK;

error:
	m_sizeBitmap.cx = 0;
	m_sizeBitmap.cy = 0;
	if (m_pImage != NULL) {
		delete m_pImage;
		m_pImage = NULL;
	}
	return hr;
#endif
}

int Cq2chwmImage::GetWidth()
{
	if (m_hBitmap == NULL) return -1;
	return m_sizeBitmap.cx;
}

int Cq2chwmImage::GetHeight()
{
	if (m_hBitmap == NULL) return -1;
	return m_sizeBitmap.cy;
}

CSize Cq2chwmImage::getAdjustSize(
	const CSize sizeImage,		// 摜IWiTCY
	const CSize sizeHint)		// qgTCY(̃TCYɎ܂CSizeԂ)
{
	CSize sizeRet;
	if (sizeHint.cx < sizeHint.cy) {
		// 
		sizeRet.cx = sizeImage.cx * sizeHint.cx / sizeImage.cx;
		sizeRet.cy = sizeImage.cy * sizeHint.cx / sizeImage.cx;
	} else {
		// c
		sizeRet.cx = sizeImage.cx * sizeHint.cy / sizeImage.cy;
		sizeRet.cy = sizeImage.cy * sizeHint.cy / sizeImage.cy;
	}
	return sizeRet;
}
