#!/usr/bin/env python3
# -*- coding: utf-8 -*-

#	Copyright © 2014 dyknon
#
#	This file is part of NicoNicoMemories.
#
#	NicoNicoMemories is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.

import nicovideo.access
import nicovideo.comment
import nicovideo.tools
import nicovideo.logger
import sys
import re
import locale
import time
import mimetypes

version = "0.1.1.1 (beta)"

def do_download(movid, movie=True, res=True, conv=True):
	m = nicovideo.access.Video(movid)
	print("動画の基本情報取得中:", movid)
	m.get_standard_info()
	filename = m.title + "[" + movid + "]"
	system_encoding = locale.getpreferredencoding()
	filename = filename.encode(system_encoding, "replace")
	filename = filename.decode(system_encoding, "replace")
	print("処理を開始します:", filename)
	cmfn = fnf(filename + ".xml")
	if res:
		print("\tコメントダウンロード...")
		conn = m.generate_connection_to_coments()
		res = conn.getresponse()
		if res.status == 200:
			filehandle = open(cmfn, mode="wb")
			filesize = int(res.getheader("Content-Length", default=-1))
			sizedled = 0
			lastprint = -1
			while True:
				buf = res.read(1024)
				sizedled += len(buf)
				nowtime = int(time.time())
				if lastprint != nowtime:
					lastprint = nowtime
					if filesize >= 0:
						pst = int(sizedled / filesize * 100 + 0.5)
						print("\t\t{}%完了 {}byte/{}byte". \
								format(pst, sizedled, filesize))
					else:
						print("\t\t{}byte 完了".format(sizedled))
				if len(buf) == 0:
					if filesize >= 0:
						pst = int(sizedled / filesize * 100 + 0.5)
						print("\t\t{}byte/{}byte をダウンロードしました". \
								format(sizedled, filesize))
					else:
						print("\t\t{}byte ダウンロードしました".format(sizedled))
					break
				filehandle.write(buf)
		else:
			raise "コメントダウンロード失敗"
		conn.close()
		print("\t完了")
	if movie:
		print("\t動画ダウンロード...")
		conn = m.generate_connection_to_video()
		res = conn.getresponse()
		if res.status == 200:
			mimetype = res.getheader("Content-Type", default="unknown")
			filename_ext = mimetypes.guess_all_extensions(mimetype)
			filename_ext.append("." + mimetype[mimetype.find("/")+1:])
			filename_tail = ""
			if m.info["play_video_url"][len(m.info["play_video_url"])-3:] \
					== "low":
				print("\t\t動画はエコノミーモードでダウンロードされます...")
				filename_tail += "low"
			filename_tail += filename_ext[0]
			filehandle = open(fnf(filename+filename_tail), mode="wb")
			filesize = int(res.getheader("Content-Length", default=-1))
			sizedled = 0
			lastprint = -1
			while True:
				buf = res.read(1024)
				sizedled += len(buf)
				nowtime = int(time.time())
				if lastprint != nowtime:
					lastprint = nowtime
					if filesize >= 0:
						pst = int(sizedled / filesize * 100 + 0.5)
						print("\t\t{}%完了 {}byte/{}byte". \
								format(pst, sizedled, filesize))
					else:
						print("\t\t{}byte 完了".format(sizedled))
				if len(buf) == 0:
					if filesize >= 0:
						pst = int(sizedled / filesize * 100 + 0.5)
						print("\t\t{}byte/{}byte をダウンロードしました". \
								format(sizedled, filesize))
					else:
						print("\t\t{}byte ダウンロードしました".format(sizedled))
					break
				filehandle.write(buf)
		else:
			raise "コメントダウンロード失敗"
		conn.close()
		print("\t完了")
	if conv:
		print("\tコメントを変換します:", cmfn)
		if not "playerinfo" in m.info_downloaded:
			m.get_player_info()
		if "is_wide" in m.info and int(m.info["is_wide"]):
			vs = nicovideo.comment.VirtualScreen("16:9")
		else:
			vs = nicovideo.comment.VirtualScreen("4:3")
		print("\t\txml読み込み中...")
		filehandle = open(cmfn, mode="rb")
		x = nicovideo.comment.interpret_xml(filehandle)
		vs.add(x["threads"])
		print("\t\t完了")
		filehandle = open(fnf(filename + ".ass"), mode="wb")
		print("\t\tass化中...")
		filehandle.write(vs.get_ass().encode("UTF-8", "replace"))
		print("\t\t完了")

midfinder = re.compile(r"^\s*(?:(?:(?:(?:(?:http:)?//?)?www.nicovideo.jp)?/)?watch/)?([a-z]{2}[0-9]+)(?:\?.*)?\s*$")
midfinder2 = re.compile(r"^\s*(?:(?:(?:(?:http:)?//?)?www.nicovideo.jp)?/)?watch/((?:[a-z]{2})?[0-9]+)(?:\?.*)?\s*$")
fnf = nicovideo.tools.filename_fixer
argindex = 1
do_movie_download = True
do_res_download = True
do_convert = True
run_dialogue_mode = True
run_mode = ""
listof_runmode = {
	"download":	"download",
	"convert":	"convert",
	"dl":		"download",
	"conv":		"convert",
	"toass":	"convert"
}
while argindex < len(sys.argv):
	if sys.argv[argindex][:2] == "--":
		argname = sys.argv[argindex][2:]
		print("そんなオプションは知らん:", sys.argv[argindex])
		argindex += 1
		continue
	elif sys.argv[argindex][0] == "-":
		for arg in sys.argv[argindex][1:]:
			if arg == "v":
				argindex += 1
				loglevel = sys.argv[argindex]
				nicovideo.logger.set_loglevel(loglevel)
				break
			elif arg == "s":
				argindex += 1
				worklist = sys.argv[argindex]
				do_movie_download = False
				do_res_download = False
				do_convert = False
				for work in worklist:
					if work == "v":
						do_movie_download = True
					elif work == "r":
						do_res_download = True
					elif work == "c":
						do_convert = True
				break
			else:
				print("そんなオプションは知らん: -{}".format(arg))
		argindex += 1
		continue
	elif not run_mode and sys.argv[argindex] in listof_runmode:
		run_mode = listof_runmode[sys.argv[argindex]]
		run_dialogue_mode = False
		argindex += 1
		continue
	elif run_mode == "download" or not run_mode:
		mo = midfinder.search(sys.argv[argindex])
		mo2 = midfinder2.search(sys.argv[argindex])
		if mo:
			do_download(mo.group(1), do_movie_download, do_res_download, do_convert)
			run_dialogue_mode = False
			argindex += 1
			continue
		elif mo2:
			do_download(mo2.group(1), do_movie_download, do_res_download, do_convert)
			run_dialogue_mode = False
			argindex += 1
			continue
	elif run_mode == "convert":
		try:
			filehandle = open(sys.argv[argindex], mode="rb")
			print("動画は16:9ですか? [Y/n] ", end="")
			if input().strip().lower() == "n":
				print("4:3モードで変換します...")
				vs = nicovideo.comment.VirtualScreen("4:3")
			else:
				print("16:9モードで変換します...")
				vs = nicovideo.comment.VirtualScreen("16:9")
			print("\txml読み込み中...")
			x = nicovideo.comment.interpret_xml(filehandle)
			vs.add(x["threads"])
			print("\t完了")
			fno = ".".join(sys.argv[argindex].split(".")[:-1]) + ".ass"
			filehandle = open(fno, mode="xb")
			print("\tass化中...")
			filehandle.write(vs.get_ass().encode("UTF-8", "replace"))
			print("\t完了")
		except OSError:
			print("ファイルI/Oエラー(たぶん)")
		argindex += 1
		continue
	print("そんなオプションは知らん:", sys.argv[argindex])
	argindex += 1

if run_dialogue_mode:
	print("NicoNicoMemories", version, "(対話モード)")
	print("Copyright (C) 2014 dyknon")
	print("\"?\"と入力して確定すると、より多くの情報が表示されます。")
	while True:
		print("コマンド: ", end="")
		command = input().strip()
		if command == "?":
			print(\
"""NicoNicoMemories はニコニコ動画のコメントを字幕ファイルに変換するツールです。
ライセンスについては?lとタイプしてください。
以下のコマンドが使用できます。

?	このメッセージを出力します。
?l	ライセンスについて表示します。
d	動画を処理します
s	dコマンドの処理内容を設定します。
q	終了します""")
		elif command == "?l":
			print(\
"""
Copyright (C) 2014 dyknon

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
""")
		elif command == "d":
			print("動画IDかURLを入力してください")
			print("スペースで区切って複数指定できます")
			for movie in input().split():
				mo = midfinder.search(movie)
				mo2 = midfinder2.search(movie)
				if mo:
					do_download(mo.group(1), do_movie_download, \
								do_res_download, do_convert)
				elif mo2:
					do_download(mo2.group(1), do_movie_download, \
								do_res_download, do_convert)
				else:
					print("動画IDを検出できませんでした:", movie)
		elif command == "s":
			print("動画をダウンロードしますか? [Y/n]")
			if input().strip().lower() == "n":
				do_movie_download = False
			else:
				do_movie_download = True
			print("コメントをダウンロードしますか? [Y/n]")
			if input().strip().lower() == "n":
				do_res_download = False
			else:
				do_res_download = True
			print("コメントを変換しますか? [Y/n]")
			if input().strip().lower() == "n":
				do_convert = False
			else:
				do_convert = True
			print("設定しました: 次の操作をします: ", end="")
			if do_movie_download:
				print("動画のダウンロード ", end="")
			if do_res_download:
				print("コメントのダウンロード ", end="")
			if do_convert:
				print("コメントの変換 ", end="")
			if not (do_movie_download or do_res_download or do_convert):
				print("なし", end="")
			print("")
		elif command == "q":
			break
		else:
			print("?でコマンドの一覧を表示します")
