def _jistosjis2(c1, c2):
    if c1 <= 82:
        r1 = (c1 + 0xe1) / 2
    else:
        r1 = (c1 + 0x161) / 2
    
    if c1 % 2 == 1:
        if c2 <= 63+0x20:
            r2 = c2+0x1f
        else:
            r2 = c2+0x20
    else:
        r2 = c2+0x7e
    return r1, r2

def sjistojis2(c1, c2):
    if 0x81 <= c1 <= 0x9f:
        r1 = c1*2-0x101
    else:
        r1 = c1*2-0x181

    if c2 < 0x9f:
        if c2 >= 0x80:
            r2 = c2-0x40
        else:
            r2 = c2-0x3f
    else:
        r1 += 1
        r2 = c2 - 0x9e
    
    return r1, r2


def readfile(fname):
    lines = open(fname).readlines()
    lines = [l.split(",") for l in lines if l]
    lines = [(int(l[0], 16), int(l[1], 16)) for l in lines]
    return lines
    
def readmap(fname, dict):
    for sjis, euc in readfile(fname):
        r1, r2 = sjistojis2(sjis>>8, sjis&0xff)
        j = r1 << 8 | (r2)
        if euc <> (j+0xa0a0):
            dict[sjis] = euc-0x8080
            
if __name__ == '__main__':
    s2j = {}
    readmap("ibmtoeuc.txt", s2j)
    readmap("necibmtoeuc.txt", s2j)
    readmap("nectoeuc.txt", s2j)
    
    print '''
/* SJIS - JIS conversion table */

unsigned int tbl_sjis2jis[] = {
'''
    sjis = s2j.keys()
    sjis.sort()
    for s in sjis:
        print "    0x%04x, 0x%04x," % (s, s2j[s])

    print "    0xffff, 0xffff,"
    print "};"


    print '''
/* JIS - SJIS conversion table */

unsigned int tbl_jis2sjis[] = {
'''
    j2s = {}
    [j2s.setdefault(j, s) for s, j in s2j.items()]

    necibm = readfile("necibmtoeuc.txt")
    for sjis, euc in necibm:
        if j2s.has_key(euc-0x8080):
            j2s[euc-0x8080] = sjis

    nec = readfile("nectoeuc.txt")
    for sjis, euc in nec:
        if j2s.has_key(euc-0x8080):
            j2s[euc-0x8080] = sjis

    jis = j2s.keys()
    jis.sort()
    for j in jis:
        print "    0x%04x, 0x%04x," % (j, j2s[j])
    print "    0xffff, 0xffff,"

    print "};"


