/*
 *  PAT.h
 */
#ifndef __MPEG2_TS_PAT_H__
#define __MPEG2_TS_PAT_H__

#include "MPEG2/TS/Table.h"

namespace MPEG2
{
namespace TS
{

class PAT : public Table
{
public:
    uint8_t     _table_id;                  //  8
    uint8_t     _section_syntax_indicator;  //  1
                                            //  1  '0'
                                            //  2  reserved
    uint16_t    _section_length;            // 12
    uint16_t    _transport_stream_id;       // 16
                                            //  2  reserved
    uint8_t     _version_number;            //  5
    uint8_t     _current_next_indicator;    //  1
    uint8_t     _section_number;            //  8
    uint8_t     _last_section_number;       //  8
    uint16_t    _program_count;
    struct _program {
        uint16_t    _program_number;        // 16
                                            //  3  reserved
        uint16_t    _pid;                   // 13
    } *_programs;
                                            // 32  CRC

protected:
    bool decode_section();
    void reset();

public:
    PAT();
    ~PAT();
    bool isEqual(PAT *pat);
};

} // TS
} // MPEG2
#endif