/*
 *  Header.h
 */
#ifndef __MPEG2_TS_HEADER_H__
#define __MPEG2_TS_HEADER_H__

#include <stdint.h>

namespace MPEG2
{
namespace TS
{

extern const uint8_t    SYNC_BYTE;
extern const uint8_t    PACKET_SIZE;

class Header
{
public:
    uint8_t     _sync_byte;                     //  8
    uint8_t     _transport_error;               //  1
    uint8_t     _payload_unit_start;            //  1
    uint8_t     _transport_priority;            //  1
    uint8_t     _pid;                           // 13
    uint8_t     _transport_scramble_control;    //  2
    uint8_t     _adaptation_field_control;      //  2
    uint8_t     _cyclic_counter;                //  4

    Header(uint8_t *packet);
};

} // TS
} // MPEG2
#endif