/*
 *  Properties.cpp
 */

#define __PROPERTIES_IMPL__
#include "Properties.h"

Properties::Properties()
{
    _path = NULL;
}

Properties::~Properties()
{
    if (_path != NULL)
    {
        free(_path);
    }
}

bool Properties::init(const char *path)
{
    bool result = false;
    if ((path != NULL) && (_path == NULL))
    {
        _path = strdup(path);
        if (_path != NULL)
        {
            [_dict release];
            NSString *p = [[NSString alloc] initWithCString:path encoding:NSUTF8StringEncoding];
            NSDictionary *d = [[NSDictionary alloc] initWithContentsOfFile:p];
            if (d != nil)
            {

                _dict = [[NSMutableDictionary alloc] initWithDictionary:d];
            }
            else
            {
                _dict = [[NSMutableDictionary alloc] initWithCapacity:0];
                update();
            }
            [d release];
            [p release];
            result = true;
        }
    }
    return result;
}

void Properties::update()
{
    NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];

    NSData *xmlData;
    NSString *error = nil;
    xmlData = [NSPropertyListSerialization dataFromPropertyList:_dict
                                                         format:NSPropertyListXMLFormat_v1_0
                                               errorDescription:&error];
    if (xmlData)
    {
        NSString *path = [NSString stringWithCString:_path encoding:NSUTF8StringEncoding];
        [[NSFileManager defaultManager] createFileAtPath:path contents:xmlData attributes:nil];
    }
    [pool release];
}

bool Properties::setIntegerForKey(int value, const char *key)
{
    bool result = Dictionary::setIntegerForKey(value, key);
    update();
    return result;
}

bool Properties::setDictionaryForKey(Dictionary *dictionary, const char *key)
{
    bool result = Dictionary::setDictionaryForKey(dictionary, key);
    update();
    return result;
}

bool Properties::setBoolForKey(bool value, const char *key)
{
    bool result = Dictionary::setBoolForKey(value, key);
    update();
    return result;
}

bool Properties::setStringForKey(const char *str, const char *key)
{
    bool result = Dictionary::setStringForKey(str, key);
    update();
    return result;
}

bool Properties::setStringWithEncodingForKey(const char *str, const char *encoding, const char *key)
{
    bool result = Dictionary::setStringWithEncodingForKey(str, encoding, key);
    update();
    return result;
}
