/*
 *  Controller.h
 */
#ifndef __PTX_PTXD_CONTROLLER_H__
#define __PTX_PTXD_CONTROLLER_H__

#include "PTx/PTxD/Tuner.h"
#include "NetTuner.h"
#include "Properties.h"

namespace PTx
{
namespace PTxD
{

#define kPTxD_SYS_NAME              "PTxD"
#define kPTxD_SYS_VERSION           "0.1a"

#define kPTxD_KEY_HTTP_PORT         "HTTP Port"
#define kPTxD_KEY_HC_PORT           "HC Port"
#define kPTxD_KEY_ROOT_PATH         "RootPath"
#define kPTxD_KEY_TUNERS            "Tuners"
#define kPTxD_KEY_INITIALIZED       "Initialized"
#define kPTxD_KEY_TYPE              "Type"
#define kPTxD_KEY_CHANNELS          "Channels"
#define kPTxD_KEY_CHANNEL_ID        "ChannelID"
#define kPTxD_KEY_CURRENT_CHANNEL   "CurrentChannel"


#define kPTxD_FILE_INFO             "info.xml"
#define kPTxD_FILE_STATUS           "status.xml"
#define kPTxD_FILE_SHUTDOWN         "shutdown"
#define kPTxD_FILE_REBOOT           "reboot"
#define kPTxD_FILE_SLEEP            "sleep"
#define kPTxD_FILE_CH               "ch"
#define kPTxD_FILE_STREAMING        "streaming"
#define kPTxD_FILE_RECORDING        "recording"
#define kPTxD_FILE_RESERVE          "reserve"
#define kPTxD_FILE_LOCK             "lock"

#define kPTxD_PARAM_SID             "sid"
#define kPTxD_PARAM_DESTINATION     "dst"
#define kPTxD_PARAM_NAME            "name"


#define kPTxD_HTTP_STATUS_OK                200
#define kPTxD_HTTP_STATUS_BAD_REQUEST       400
#define kPTxD_HTTP_STATUS_NOT_FOUND         404
#define kPTxD_HTTP_STATUS_NOT_ACCEPTABLE    406
#define kPTxD_HTTP_STATUS_NOT_IMPLEMENTED   501

class Controller
{
private:
    pthread_mutex_t _lock;
    pthread_cond_t  _cond;

    enum _STATUS
    {
        ST_IDLE,
        ST_RUN,
        ST_STOP,
        ST_DONE
    }               _status;
    int             _fd;

    int             _tuner_count;
    Tuner *         _tuners[MAX_TUNER_COUNT * MAX_DEV_COUNT];
    char *          _pathsForRecording[MAX_TUNER_COUNT * MAX_DEV_COUNT];
    int             _fdsForRecording[MAX_TUNER_COUNT * MAX_DEV_COUNT];

    Properties *    _props;

    // methods
    bool init_properties(const char *path);
    bool init_tuners();
    bool init_httpd();

public:
    Controller();
    ~Controller();
    bool start(const char *path);
    void stop();
    void waitFinished();

    void run();
    void request(int fd, char *client);
    void request(int fd, char *client, uint32_t tuner, char *path, int *status, Dictionary **body);
    bool startRecording(uint32_t tuner, char *name);
    void stopRecording(uint32_t tuner);
    void tick();
};

} // PTxD
} // PTx
#endif

