/*
 *  Table.cpp
 */

#include "MPEG2/TS/Header.h"
#include "MPEG2/TS/Table.h"

namespace MPEG2
{
namespace TS
{

Table::Table()
{
//    printf("Table()\n");
    _section = NULL;
}

Table::~Table()
{
//    printf("~Table()\n");
    if (_section != NULL)
    {
        free(_section);
    }
}

bool Table::decode(uint8_t *packet)
{
    bool result = false;

    Header header(packet);
    if (!header._transport_error && (header._adaptation_field_control != 0))
    {
        uint16_t length;
        if (_section == NULL)
        {
            length = (((packet[0x06] << 8) + packet[0x07]) & 0x0FFF) + 3;
            _section = (uint8_t *)malloc(length);
            _length = (length < 183) ? length : 183;
            memcpy(_section, &packet[0x05], _length);
        }
        else
        {
            length = (((_section[0x01] << 8) + _section[0x02]) & 0x0FFF) + 3;
            uint16_t cpylen = ((length - _length) < 184) ? (length - _length) : 184;
            memcpy(&_section[_length], &packet[0x04], cpylen);
            _length += cpylen;
        }

        if (_length == length)
        {
            // check CRC
            if (true /* check CRC */)
            {
                // decode
                result = decode_section();
            }
            free(_section);
            _section = NULL;
        }
    }
    else
    {
//        printf("transport error.\n");
    }

    return result;
}

bool Table::decode_section()
{
    return false;
}

/*
//
// CRC 計算
//
int GetCrc32(
	unsigned char* data,				// [in]		CRC 計算対象データ
	int len)							// [in]		CRC 計算対象データ長
{
	int crc;
	int i, j;

	crc = 0xFFFFFFFF;
	for (i = 0; i < len; i++)
	{
		char x;
		x = data[i];

		for (j = 0; j < 8; j++)
		{
			int c;
			int bit;

			bit = (x >> (7 - j)) & 0x1;

			c = 0;
			if (crc & 0x80000000)
			{
				c = 1;
			}

			crc = crc << 1;

			if (c ^ bit)
			{
				crc ^= 0x04C11DB7;
			}

			crc &= 0xFFFFFFFF;
		}
	}

	return crc;
}

*/

} // TS
} // MPEG2