/*
 *  Header.cpp
 */
#include "Header.h"

namespace MPEG2
{
namespace TS
{

const uint8_t SYNC_BYTE     = 0x47;
const uint8_t PACKET_SIZE   = 188;

Header::Header(uint8_t *packet)
{
    _sync_byte                  = packet[0x00];
    _transport_error            = (packet[0x01] & 0x80) >> 7;
    _payload_unit_start         = (packet[0x01] & 0x40) >> 6;
    _transport_priority         = (packet[0x01] & 0x20) >> 5;
    _pid                        = ((packet[0x01] << 8) + packet[0x02]) & 0x1FFF;
    _transport_scramble_control = (packet[0x03] & 0xc0) >> 6;
    _adaptation_field_control   = (packet[0x03] & 0x30) >> 4;
    _cyclic_counter             = packet[0x03] & 0x0F;
}

} // TS
} // MPEG2