/*
 *  Analyzer.cpp
 */
#include "Analyzer.h"

namespace MPEG2
{
namespace TS
{

#pragma mark -
#pragma mark Analyzer

Analyzer::Analyzer(Delegate *delegate)
{
    _delegate = delegate;
    _pat = new PAT();
    _sdt = new SDT();
    _pmt_list = NULL;
    _flag = 0;
}

Analyzer::~Analyzer()
{
    delete _pat;
    delete _sdt;

    if (_pmt_list != NULL)
    {
        delete _pmt_list;
    }
}

void Analyzer::put(uint8_t *buf, int32_t length)
{
    for (int32_t offset = 0; offset < length; offset += PACKET_SIZE)
    {
        if (buf[offset] == SYNC_BYTE)
        {
            uint16_t pid = ((buf[offset + 1] << 8) + buf[offset + 2]) & 0x1FFF;
            switch (pid)
            {
            case 0x0000:    // PAT
                if (_pat->decode(&buf[offset]))
                {
                    // Update PMT LIST
#if 0
                    if (_pmt_list != NULL)
                    {
                        delete _pmt_list;
                        _pmt_list = NULL;
                    }
#endif
if (_pmt_list == NULL)
{
                    for (int i = 0; i < _pat->_program_count; ++i)
                    {
                        if (_pmt_list == NULL)
                        {
                            _pmt_list = new PMT_LIST(_pat->_programs[i]._program_number, _pat->_programs[i]._pid);
                        }
                        else
                        {
                            _pmt_list->add(_pat->_programs[i]._program_number, _pat->_programs[i]._pid);
                        }
                    }
}
                    _delegate->detect(_pat);
                }
                _delegate->packet(PACKET_TYPE_PAT, &buf[offset]);
                break;

            case 0x0011:    // SDT
                if ((_flag & FLAG_SDT) == FLAG_SDT)
                {
                    if (_sdt->decode(&buf[offset]))
                    {
                        _delegate->detect(_sdt);
                    }
                }
                break;
    
            default:
                {
                    PMT_LIST *cur = _pmt_list;
                    while (cur != NULL)
                    {
                        if (cur->_pid == pid)
                        {
                            if (cur->_pmt->decode(&buf[offset]))
                            {

//printf("\nprogram_number: 0x%04x\n", cur->_program_number);
//for (int i = 0; i < cur->_pmt->_element_count; ++i)
//{
//    printf("type: 0x%02x, pid:0x%04x\n", cur->_pmt->_elements[i]._stream_type, cur->_pmt->_elements[i]._elementary_PID);
//}
                                _delegate->detect(cur->_pmt);
                            }
                            _delegate->packet(PACKET_TYPE_PMT, cur->_program_number, &buf[offset]);
                            break;
                        }
                        else if (cur->_pmt->_PCR_PID == pid)
                        {
                            _delegate->packet(PACKET_TYPE_PCR, cur->_program_number, &buf[offset]);
                            break;
                        }
                        else
                        {
                            bool found = false;
                            for (int i = 0; i < cur->_pmt->_element_count; ++i)
                            {
                                if (cur->_pmt->_elements[i]._elementary_PID == pid)
                                {
//printf("pid: 0x%04x\n", pid);
                                    _delegate->packet(PACKET_TYPE_ES, cur->_program_number, cur->_pmt->_elements[i]._stream_type, &buf[offset]);
                                    found = true;
                                    break;
                                }
                            }
                            if (found)
                            {
                                break;
                            }
                        }
                        cur = cur->_next;
                    }
                }
                break;
            }
        }
    }
}

void Analyzer::setEnableSDT(bool onoff)
{
    if (onoff)
    {
        _flag |= FLAG_SDT;
    }
    else
    {
        _flag &= ~(FLAG_SDT);
    }
}

#pragma mark -
#pragma mark PMT_LIST

Analyzer::PMT_LIST::PMT_LIST(uint16_t program_number, uint16_t pid)
{
    _program_number = program_number;
    _pid            = pid;
    _pmt            = new PMT();
    _prev           = NULL;
    _next           = NULL;
}

Analyzer::PMT_LIST::~PMT_LIST()
{
    delete _pmt;
    if (_next != NULL)
    {
        delete _next;
    }
}

void Analyzer::PMT_LIST::add(uint16_t program_number, uint16_t pid)
{
    if (_next == NULL)
    {
        _next = new PMT_LIST(program_number, pid);
        _next->_prev = this;
    }
    else
    {
        _next->add(program_number, pid);
    }
}

} // TS
} // MPEG2
