//
//  PT1Client.h
//

#include <IOKit/IOService.h>
#include <IOKit/IOUserClient.h>
#include "PT1Device.h"

class PT1Client : public IOUserClient
{
#if	MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_4
    OSDeclareDefaultStructors(PT1Client)
#else
    OSDeclareDefaultStructors(PT1Client)
#endif
    
protected:
    PT1Device*					fProvider;
    task_t									fTask;
	bool									fCrossEndian;
#if MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_4
    static const IOExternalMethod			sMethods[kNumberOfMethods];
#else
    static const IOExternalMethodDispatch	sMethods[kNumberOfMethods];
#endif
      
public:
    // IOUserClient methods
    virtual void stop(IOService* provider);
    virtual bool start(IOService* provider);
    
	virtual bool initWithTask(task_t owningTask, void* securityToken, UInt32 type, OSDictionary* properties);

    virtual IOReturn clientClose(void);
    virtual IOReturn clientDied(void);

	virtual bool willTerminate(IOService* provider, IOOptionBits options);
	virtual bool didTerminate(IOService* provider, IOOptionBits options, bool* defer);
	
    virtual bool terminate(IOOptionBits options = 0);
    virtual bool finalize(IOOptionBits options);
	virtual IOReturn clientMemoryForType(UInt32 type, IOOptionBits * options, IOMemoryDescriptor ** memory);

protected:	

#if MAC_OS_X_VERSION_MIN_REQUIRED <= MAC_OS_X_VERSION_10_4
	// Legacy KPI - only supports access from 32-bit user processes.
	virtual IOExternalMethod* getTargetAndMethodForIndex(IOService** targetP, UInt32 index);
#else	
	// KPI for supporting access from both 32-bit and 64-bit user processes beginning with Mac OS X 10.5.
	virtual IOReturn externalMethod(uint32_t selector, IOExternalMethodArguments* arguments,
									IOExternalMethodDispatch* dispatch, OSObject* target, void* reference);
#endif

    // User Interface
#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
	static IOReturn sGetDeviceInfo(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
	virtual IOReturn getDeviceInfo(DeviceInfo *deviceInfo, uint32_t *structSize);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
	static IOReturn sOpen(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
	virtual IOReturn open(uint32_t *status);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
	static IOReturn sClose(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn close(uint32_t *status);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
	static IOReturn sGetPciClockCounter(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getPciClockCounter(uint32_t *status, uint32_t *counter);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetPciLatencyTimer(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setPciLatencyTimer(uint32_t *status, uint32_t latencyTimer);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetPciLatencyTimer(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getPciLatencyTimer(uint32_t *status, uint32_t *latencyTimer);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetLnbPower(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setLnbPower(uint32_t *status, uint32_t lnbPower);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetLnbPower(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getLnbPower(uint32_t *status, uint32_t *lnbPower);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetLnbPowerWhenClose(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setLnbPowerWhenClose(uint32_t *status, uint32_t lnbPower);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetLnbPowerWhenClose(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getLnbPowerWhenClose(uint32_t *status, uint32_t *lnbPower);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetTunerPowerReset(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setTunerPowerReset(uint32_t *status, uint32_t tunerPowerReset);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetTunerPowerReset(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getTunerPowerReset(uint32_t *status, uint32_t *tunerPowerReset);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sInitTuner(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn initTuner(uint32_t *status, uint32_t tuner);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetTunerSleep(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setTunerSleep(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t sleep);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetTunerSleep(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getTunerSleep(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *sleep);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetFrequency(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setFrequency(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t channel, int32_t offset);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetFrequency(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getFrequency(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *channel, int32_t *offset);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetFrequencyOffset(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getFrequencyOffset(uint32_t *status, uint32_t tuner, ISDB isdb, int32_t *clock, int32_t *carrier);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetCnAgc(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getCnAgc(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *cn100, uint32_t *currentAgc, uint32_t *maxAgc);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetIdS(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setIdS(uint32_t *status, uint32_t tuner, uint32_t tsid);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetIdS(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getIdS(uint32_t *status, uint32_t tuner, uint32_t *tsid);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetCorrectedErrorRate(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getCorrectedErrorRate(uint32_t *status, uint32_t tuner, ISDB isdb, LayerIndex layerIndex, ErrorRate *errorRate);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sResetCorrectedErrorCount(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn resetCorrectedErrorCount(uint32_t *status, uint32_t tuner, ISDB isdb);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetErrorCount(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getErrorCount(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *count);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetTmccS(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getTmccS(uint32_t *status, uint32_t tuner, TmccS *tmcc);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetLayerS(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getLayerS(uint32_t *status, uint32_t tuner, LayerS *layer);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetTmccT(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getTmccT(uint32_t *status, uint32_t tuner, TmccT *tmcc);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetLockedT(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getLockedT(uint32_t *status, uint32_t tuner, bool locked[LAYER_COUNT_T]);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetLayerEnable(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setLayerEnable(uint32_t *status, uint32_t tuner, ISDB isdb, LayerMask layerMask);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetLayerEnable(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getLayerEnable(uint32_t *status, uint32_t tuner, ISDB isdb, LayerMask *layerMask);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetBufferInfo(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setBufferInfo(uint32_t *status, const BufferInfo *bufferInfo);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetBufferInfo(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getBufferInfo(uint32_t *status, BufferInfo *bufferInfo);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sResetTransferCounter(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn resetTransferCounter(uint32_t *status);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sIncrementTransferCounter(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn incrementTransferCounter(uint32_t *status);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetStreamEnable(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setStreamEnable(uint32_t *status, uint32_t tuner, ISDB isdb, bool enable);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetStreamEnable(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getStreamEnable(uint32_t *status, uint32_t tuner, ISDB isdb, bool *enable);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetStreamGray(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setStreamGray(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t gray);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetStreamGray(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getStreamGray(uint32_t *status, uint32_t tuner, ISDB isdb, uint32_t *gray);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sSetTransferEnable(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn setTransferEnable(uint32_t *status, bool enable);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetTransferEnable(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getTransferEnable(uint32_t *status, bool *enable);

#if MAC_OS_X_VERSION_MIN_REQUIRED > MAC_OS_X_VERSION_10_4
    static IOReturn sGetTransferInfo(PT1Client* target, void* reference, IOExternalMethodArguments* arguments);
#endif
    virtual IOReturn getTransferInfo(uint32_t *status, TransferInfo *transferInfo);
};