/*
 */
#include "hw.h"
#include "pci.h"
#include "pc.h"

#define DEBUG_PT1

/* lspci -xxx の結果
Multimedia controller: Xilinx Corporation Device 211a (rev 01)
00: ee 10 1a 21 06 00 00 02 01 00 80 04 00 20 00 00
10: 00 c0 5f fd 00 00 00 00 00 00 00 00 00 00 00 00
20: 00 00 00 00 00 00 00 00 00 00 00 00 11 ef e5 de
30: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
40: 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00
50: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
60: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
70: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
80: ee 10 1a 21 06 00 00 02 01 00 80 04 00 20 00 00
90: 00 c0 5f fd 00 00 00 00 00 00 00 00 00 00 00 00
a0: 00 00 00 00 00 00 00 00 00 00 00 00 11 ef e5 de
b0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
c0: 00 00 00 00 01 00 00 00 00 00 00 00 00 00 00 00
d0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
e0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
f0: 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00
 */

// lspci結果の情報
static	char	pci_copy [256] = {
 0xee ,0x10 ,0x1a ,0x21 ,0x06 ,0x00 ,0x00 ,0x02 ,0x01 ,0x00 ,0x80 ,0x04 ,0x00 ,0x20 ,0x00 ,0x00
 ,0x00 ,0xc0 ,0x5f ,0xfd ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x11 ,0xef ,0xe5 ,0xde
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x01 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0xee ,0x10 ,0x1a ,0x21 ,0x06 ,0x00 ,0x00 ,0x02 ,0x01 ,0x00 ,0x80 ,0x04 ,0x00 ,0x20 ,0x00 ,0x00
 ,0x00 ,0xc0 ,0x5f ,0xfd ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x11 ,0xef ,0xe5 ,0xde
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x01 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00
 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00 ,0x00

};
/* PCI PT1 definitions */

/***********************************************************/
static		FILE	*fp = NULL;					// FIFOに書いたデータ
typedef struct PT1State {
    PCIDevice dev;
    char	buf[(1024 * 4)];
	int     mmio_index ;
	uint32_t	region[3];
}PT1State;

static	uint16_t	fifo_data[(64 * 1024)];				// FIFOに書くもの
static		int		fifo_max_addr = 0 ;			// FIFOに書いた最大アドレス
static		int		reg_count = 0 ;				// Scan時に書いた個数
static		int		reg_pos_count = 0 ;			// FIFOに書いた個数
static		int		fifo_write_count = 1 ;		// FIFOに書いて実行した個数
static		int		fifo_write = 0 ;			// FIFOに書いて実行した個数

typedef struct PCIPT1State {
    PCIDevice dev;
	PT1State state ;
} PCIPT1State;
/***********************************************************/
enum{
	START,
	ADDR,
	ADDR2,
	DATA,
	END
};

static	void	Dump2()
{

	int		lp ;
	int		lp2 = 0;
	int	AllVal = 0;
	int	Addr = 0;
	int	addr ;
	int	val ;
	int			state = START;

	fprintf(stdout, "========= FIFO COUNT(%03d) =========\n", fifo_write_count);
	// ここから解析
	for(lp = 1 ; lp <= fifo_max_addr ; lp++){
		addr = (fifo_data[lp] & ((1 << 10) - 1));
		val = ((fifo_data[lp] >> 10) & 0xFF);
		if(addr == 0){
			break ;
		}
		if(state  == START){
			// CLOCKが出たらSTARTフェーズ終了
			if((val & 0x02)){
				state = ADDR;
				continue ;
			}
		}
		if((state == ADDR) || (state == DATA)){
			// CLOCKが落ちたら再度ADDRESSへ
			if(!(val & 0x02)){
				state = ADDR ;
				lp += 2 ;
				lp2 = 0;
				continue ;
			}
			AllVal = (AllVal << 1);
			AllVal |= ((val & 1) ? 0 : 1);
			if(lp2 >= 7){
				if(state == ADDR){
					if((AllVal & 1)){
						fprintf(stdout, "受信:");
					}else{
						fprintf(stdout, "送信:");
					}
					// 10Bit Address Mode
					if((AllVal & 0xF0) == 0XF0){
						Addr = (AllVal & 0x6) << 8;
						fprintf(stdout, "10Bit Address Mode:(%02x)", Addr);
						state = ADDR2 ;
					}else{
						fprintf(stdout, "7Bit Address Mode(%02x)", (AllVal >> 1));
						state = DATA ;
					}
				}else if(state == ADDR2){
					Addr |= AllVal ;
					state = DATA ;
				}else if(state == DATA){
					fprintf(stdout, ":%02x", AllVal);
				}
				lp2 = 0 ;
				AllVal = 0 ;
				val = ((fifo_data[lp + 2] >> 10) & 0xFF);
				// Readの場合は飛ばす
				if((val & 0x04)){
					lp += 1;
				}
				lp += 3 ;
			}else{
				lp2 += 1 ;	// ビット位置
				val = ((fifo_data[lp + 2] >> 10) & 0xFF);
				// Readの場合は飛ばす
				if((val & 0x04)){
					lp += 1;
				}
			}
			lp += 2;	// negaedgeと先頭edgeを飛ばす
		}
	}
	fprintf(stdout, "\n");
	memset(fifo_data, '\0', sizeof(fifo_data));
}
static	void		DumpWords(FILE *fp, int reg_pos_count)
{
	int		lp ;
	uint32_t	addr ;
	uint32_t	val ;
#if 0
	if(fp == NULL){
		return ;
	}
	fprintf(fp, "\n========= FIFO COUNT(%03d:%d) =========\n", fifo_write_count,
			reg_pos_count);
	// 初期化時のバカ避け
	if(fifo_max_addr >= 1024){
		fifo_max_addr = 512 ;
	}
	for(lp = 0 ; lp <= fifo_max_addr ; lp++){
		if((lp) && (!(lp % 8))){
			fprintf(fp, "\n");
		}
		if((!(lp % 8))){
			fprintf(fp, "%04x: ", (lp * 2));
		}
		addr = (fifo_data[lp] & ((1 << 10) - 1));
		val = ((fifo_data[lp] >> 10) & 0xFF);
		fprintf(fp, "%03x/%02x ", addr, val);
	}
#endif
	Dump2();
#if 0
	fflush(fp);
#endif
	fifo_write_count += 1 ;
	memset(fifo_data, '\0', sizeof(fifo_data));
}
static void pt1_save(QEMUFile* f,void* opaque)
{
    printf("%s: \n", __FUNCTION__);
}

static int pt1_load(QEMUFile* f,void* opaque,int version_id)
{
    printf("%s: \n", __FUNCTION__);
	return 0;
}

/***********************************************************/
static void PT1pci_mmio_writeb(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: addr=%08lx value=%lx\n", __FUNCTION__, addr, val);
}

static void PT1pci_mmio_writew(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: addr=%08lx value=%lx\n", __FUNCTION__, addr, val);
}

static void PT1pci_mmio_writel(void *opaque, target_phys_addr_t addr, uint32_t val)
{
    PT1State *s = opaque;
	static	int			rc = 0;
	static	int			fifo_cnt = 0;
	uint32_t	*ptr = (uint32_t *)s->buf ;
	uint32_t	offset ;
	char		fname[256];


//		printf("%s: addr=%08lx value=%lx\n", __FUNCTION__, addr, s->region[0]);
//    addr -= s->region[0];

	fifo_write = 0 ;
	if(addr == 0x10){
		if(fp == NULL){
			memset(fname, '\0', sizeof(fname));
			sprintf(fname, "/tmp/reg_all_%03d.data", fifo_write_count);
			fp = fopen(fname, "w+");
			fifo_max_addr = 0 ;
		}
		//オフセットを求める。
		reg_pos_count += 1 ;
        offset = ((val >> 18) & ((1 << 14) - 1));
        fifo_data[offset] = (val & ((1 << 18) - 1));
        if(fifo_max_addr < offset){
            fifo_max_addr = offset;
        }

	}else{
		if(reg_pos_count){
			DumpWords(fp, reg_pos_count);
			fifo_write = 1 ;
			fclose(fp);
			fp = NULL ;
		}
		reg_pos_count = 0 ;
	    printf("%s: addr=%08lx value=%lx\n", __FUNCTION__, addr, val);
	}
/*
	if(access("/tmp/isdb-s", 0) == F_OK){
		if(rc == 0){
			if(fp != NULL){
				fprintf(fp, "Scan Channels\n");
			}
			rc += 1 ;
		}
		if(addr != 0x10){
			reg_count += 1 ;
		}
	}
*/
	ptr[(addr % sizeof(uint32_t))] = val ;
}

static uint32_t PT1pci_mmio_readb(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: addr=%08lx \n", __FUNCTION__, addr);
	return 0 ;
}

static uint32_t PT1pci_mmio_readw(void *opaque, target_phys_addr_t addr)
{
    PT1State *s = opaque;
    addr -= s->region[0];
    printf("%s: addr=%08lx \n", __FUNCTION__, addr);

	return 0 ;
}

static uint32_t PT1pci_mmio_readl(void *opaque, target_phys_addr_t addr)
{
	static	uint32_t	rc = 0;
	static		int		f_f_f = 0;
	static		int		f = 0;
#define		MAX_CNT		16
	static	uint32_t	rc_rec[MAX_CNT] ={
		// LOCK      TMCCのはず。正常な値って何？
		0xff414100, 0xe0208871, 0x40024001,
		//                      ↑ここの値が判らない。TMCCのリトライ時に取る値
		// TSID        TSID        TSID       TSID
		0x40024001, 0xFFFFFFFF, 0XFFFFFFFF, 0xFFFFFFFF,
		// CN?      CN?         AGC(下8BIT)
		0x00110022, 0x00330044, 0x00000066,
		// 各TS情報
		// 取得したTSID
		//       Mode Slot
		//        上位2バイト：モード
		//                      高層モード、低層モード
		//        下位2バイト：スロット数
		//                      高層モード、低層モード
		0x4002, 0x0403110D,
		0x4001, 0x0403110D,
		// ここがクロック周波数誤差とキャリア周波数誤差？
		// 正常な値が判らない
		10, 11
};

    PT1State *s = opaque;
	uint32_t	*ptr = (uint32_t *)s->buf ;

//    addr -= s->region[0];
	if(access("/tmp/isdb-s", 0) == F_OK){
		printf("Scan Channels\n");
		if(addr == 0x08){
			printf("Data ?(%d)\n", f_f_f);
			rc = rc_rec[(f_f_f % MAX_CNT)] ;
			if(!(f_f_f % MAX_CNT)){
				if(fp != NULL){
					fprintf(fp, "Line Scan Start\n");
				}
			}
			f_f_f += 1 ;
		}else{
			rc = 0x00000041;
		}
	}else{
		if(fifo_write == 1){
			if(addr == 0){
				rc = 0x00000000;
			}else{
				rc = 0x0000004C;
			}
		}else{
			if(addr == 8){
				rc = 0x00000041;
				f = 0 ;
			}else{
				if(ptr[(addr % sizeof(uint32_t))] == 0){
					rc = 0x20;
				}else if(ptr[(addr % sizeof(uint32_t))] == 0x08){
					rc = 0x80000020;
				}else if(ptr[(addr % sizeof(uint32_t))] == 0x1000000){
					rc = 0x80000021;
				}else if(ptr[(addr % sizeof(uint32_t))] == 0x2000000){
					rc = 0x80000023;
				}else if(ptr[(addr % sizeof(uint32_t))] == 0x02){
					if(f != 0){
						rc = 0x80000027;
						f = 0 ;
					}else{
						f += 1 ;
						rc = 0x80000023;
					}
				}
			}
		}
	}
    printf("%s: addr=%08lx value=%lx\n", __FUNCTION__, addr, rc);
	return rc;
}
/***********************************************************/
static CPUWriteMemoryFunc *pt1_pci_mmio_write[] = {
    PT1pci_mmio_writeb,
    PT1pci_mmio_writew,
    PT1pci_mmio_writel
};
static CPUWriteMemoryFunc *pt1_pci_mmio_read[] = {
    PT1pci_mmio_readb,
    PT1pci_mmio_readw,
    PT1pci_mmio_readl
};
/***********************************************************/

static void pt1_map(PCIDevice *pci_dev, int region_num,
                       uint32_t addr, uint32_t size, int type)
{
	PCIPT1State *d = (PCIPT1State *) pci_dev;
    uint8_t *pci_conf;
	int		lp ;

    printf("pt1_map: region_num=%d addr=%x size = %d  type=%d\n",
			region_num, addr, size, type);

    pci_conf = d->dev.config;

	// Dump PCI Config
	printf(" Dump PCI Config\n");
	printf("00: ");
	for(lp = 0 ; lp < 64 ; lp++){
		if((!(lp % 16)) && (lp > 0)){
			printf("\n");
			printf("%02x: ", lp);
		}
		printf("%02x ", pci_conf[lp]);
	}
	printf("\n");
	if(region_num == 0) {
		cpu_register_physical_memory(addr, size, d->state.mmio_index);
		d->state.region[region_num] = addr;
	}
}

void pci_pt1_init(PCIBus *bus, int devfn)
{
    PCIPT1State *d;
	PT1State	*s ;
    uint8_t *pci_conf;
	printf("pci_pt1_init: Start\n");

    d = (PCIPT1State *)pci_register_device(bus,
                                              "PT1_DEV", sizeof(PCIPT1State),
                                              devfn,
                                              NULL, NULL);
	printf("pci_pt1_init: pci_register_device End\n");
    pci_conf = d->dev.config;

	memcpy(pci_conf, pci_copy, 256);

	s = &d->state;
	printf("pci_pt1_init: cpu_register_io_memory Start\n");
    d->state.mmio_index =
		cpu_register_io_memory(0, pt1_pci_mmio_read, pt1_pci_mmio_write,s);

	printf("pci_pt1_init: cpu_register_io_memory\n");
    pci_register_io_region(&d->dev, 0, 0x1000,
                           PCI_ADDRESS_SPACE_MEM, pt1_map);
	printf("pci_pt1_init: pci_register_io_region\n");
/*
    s = &d->pt1;
    s->irq = d->dev.irq[0];
    s->pci_dev = (PCIDevice *)d;
    pt1_reset(s);
 */
    register_savevm("pt1", 0, 3, pt1_save, pt1_load, d);
	printf("pci_pt1_init: End\n");
}
