
// Motion with glass patterns.
// Ross, J., Badcock, D. R., and Hayes, A. (2000)
// Coherent global motion in the absence of coherent velocity signals.
// Current Biology, 10, 679-682.
///+ Prefix
//// Include Psychlops Package
#include <psychlops.h>
using namespace Psychlops;    // Initially developed with Psychlops Win32 1.5.3 / 20110311
///- Prefix

///+ Stimulus drawing function
//// A function for stimulus drawing (main body)
void psychlops_main() {

	Canvas cnvs(Canvas::window);

	Image src("flower_png24.png"), rst;
try {
	FFT2::resizeImage(src, rst, 200, 200);
}catch(Exception &e) {
	std::cout << e.to_s();
}
	rst.cache();

	while(!Keyboard::esc.pushed()) {
		Display::clear(Color::green); //Clear window

		src.centering().shift(-200,0).draw();
		rst.centering().shift(200,0).draw();

		Display::flip(); // Flip frame buffers
	}

	Figures::Movie mov;
	mov.bin_path = "C:\\";
}
///- Stimulus drawing function

#if 0

#include <psychlops.h>
using namespace Psychlops;


Clock before, after;
void memoBefore() { before.update(); }
double pastTime() { after.update(); return (after-before).at_msec(); }


void psychlops_main() {


	Display target_display = Display::secondary;
	std::cout << target_display.width << std::endl;
	std::cout << Display::secondary.getHeight() << std::endl;


	Canvas display(1024, 768, Canvas::window, target_display);
	Range rng;
/*
	Mouse::show();
	Color::setGammaValue(1.0,1.0,1.0);

	double cutoff1=1.0,cutoff2=0.0;
	Widgets::Slider slider[3];
	slider[0].link(cutoff1, "cutoff1"  , 0<=rng<=256, 1);
	slider[1].link(cutoff2, "half width"  , 0<=rng<=1, 0.125);
*/

/*
	//void drawGrating(Image &img, int width, int height, double wavelength, double contrast, double orientation, double phase);
	//void drawGaussian(Image &img, double sigma, double factor);
	//void drawGabor(Image &img, double sigma, double wavelength, double contrast, double orientation, double phase);
	std::stringstream ss;
	Image img;
	for(double wavelength_=2; wavelength_<8; wavelength_+=1.0 )
	{
		for(double ori = 0; ori<180.0; ori+=30)
		{
			for(double amp = 0.25; amp<=1; amp+=0.25)
			{
				for(double phase = 0; phase<360.0; phase+=30)
				{
					Figures::drawGrating(img, 36, 36, pow(2,wavelength_), amp, ori/360*2*PI, phase/360*2*PI);
					ss.str("");
					ss << "output/Grating_wav" << pow(2,wavelength_) << "_amp" << amp << "_ori" << ori << "_pha" << phase << ".png";
					img.save(ss.str());
					//Figures::drawGrating(img, 45, 45, pow(2,wavelength_), amp, ori/360*2*PI, phase/360*2*PI);
				}
			}
		}
	}
*/

/*
	while(!Keyboard::esc.pushed()) {

		memoBefore();
		std::cout << pastTime() << std::endl;


		memoBefore();
*/

	Figures::Movie m;
	m.source.set(100,100).centering();

		//while(!Keyboard::esc.pushed()) {
		for(int j=0; j<10; j++) {
			display.clear(Color::blue);


			//img.centering().draw();
			for(int i=0; i<2; i++)
			{
				//slider[i].setDatum(Point(0,0)).shift(20, i*25 + 10).draw();
			}
			m.capture();
			//display.to(m[j], r);
			display.flip();
		}
		m.save("test.gif");
	//	std::cout << pastTime() << std::endl;
	//}* /
}
#endif
