/*
 *  psychlops_io_clipboard_Win32.cpp
 *  Psychlops Standard Library (Win32)
 *
 *  Last Modified 2010/01/05 by Kenchi HOSOKAWA
 *  (C) 2010 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include <string>
#include <windows.h>

#include "../../core/devices/psychlops_io_clipboard.h"


namespace Psychlops {

	std::string Clipboard::getText()
	{
		HANDLE hClip;
		char* pText;
		std::string tmp;
		if ( OpenClipboard( NULL ) == FALSE ) {
			return tmp;
		}
		if ((hClip = GetClipboardData( CF_TEXT ) ) == NULL) {
			return tmp;
		} else {
			pText = (char*)GlobalLock( hClip );
			tmp.append(pText);
			GlobalUnlock( hClip );
		}
		CloseClipboard();
		return tmp;
	}

}	/*	<- namespace Psycholops 	*/
