/*
 *  psychlops_io_display.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/04/05 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#include "psychlops_io_display.h"


namespace Psychlops {

	const Display::PROPERTY_DISPLAY Display::primary = Display::PROPERTY_DISPLAY(0);
	const Display::PROPERTY_DISPLAY Display::secondary = Display::PROPERTY_DISPLAY(1);
	Display::PROPERTY_DISPLAY::PROPERTY_DISPLAY(int n)
	{
		N = n;
	}
	Display::PROPERTY_DISPLAY::operator Display() const {
		if(N==0) {
			return Display::list()[0];
		} else {
			return (Display::list().size()>1) ? Display::list()[1] : Display::list()[0];
		}
	}
	int Display::PROPERTY_DISPLAY::getWidth() const { return ((Display)(*this)).width; }
	int Display::PROPERTY_DISPLAY::getHeight() const { return ((Display)(*this)).height; }
	int Display::PROPERTY_DISPLAY::getColorDepth() const { return ((Display)(*this)).color_depth; }
	double Display::PROPERTY_DISPLAY::getRefreshRate() const { return ((Display)(*this)).refresh_rate; }
	Rectangle Display::PROPERTY_DISPLAY::getArea() const { return ((Display)(*this)).area; }



	Display::Display(const Display &disp) : api_(disp.api_) {
		width = disp.width;
		height = disp.height;
		color_depth = disp.color_depth;
		refresh_rate = disp.refresh_rate;
		name = disp.name;
		area = disp.area;
	}

	Display::~Display() {
	}

	Display& Display::operator =(const Display& disp) {
		width = width;
		height = disp.height;
		color_depth = disp.color_depth;
		refresh_rate = disp.refresh_rate;
		name = disp.name;
		area = disp.area;
		api_ = disp.api_;
		return *this;
	}



}	/*	<- namespace Psycholops 	*/
