/*
 *  psychlops_io_API_Win32.h
 *  Psychlops Standard Library (Win32)
 *
 *  Last Modified 2006/01/05 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_IO_API_WIN32
#define HEADER_PSYCHLOPS_IO_API_WIN32


#include <windows.h>

#include "psychlops_io_clock_Win32.h"
#include "../win32gl/psychlops_g_API_win32gl.h"
#include "../../core/devices/psychlops_io_hid.h"


namespace Psychlops {

	class APIHIDProperties;
	class APIKeyboardProperties;
	class APIMouseProperties;
	class APICanvasProperties;
	class Mouse;
	class Keyboard;
	class HumanInterfaceDevice;

	class APIHIDProperties {
		friend class APICanvasProperties;
		friend class Mouse;
		friend class Keyboard;
		friend class HumanInterfaceDevice;

		private:
		static HDC the_display_;							//	Handle for dummy Device Context
		static WNDCLASSEX wcx;				//	Handle for dummy WindowClassEx
		static HWND hWnd;						//	Handle for dummy Window
		static HANDLE io_thread;
		static DWORD io_threadID;
		static bool refresh_needed;

		public:
		static void initialize();
		static void finalize();

		static void listen();
		//  Event Based Keyboard-Accept Code(Hibernated)
		//  static void setKeyboardListener();
//		static DWORD WINAPI setupListener(LPVOID vdParam);
//		static void loopListener();
		static void startListener();
		static void stopListener();
		static void bindKeyCode();

		static bool get(Keyboard::Key key, Keyboard::KeyState state);
		static bool get(Mouse::Button button, Mouse::ButtonState state);
		static void setPointerPosition(int x, int y);
		static void update();
		static void updatePointerPosition();


		private:
		static const int keycnt_ = 256;
		static const int pressedbit_ = 128;
		static unsigned long keybinder_[keycnt_];
		static BYTE states_[4][keycnt_];
	};


/*
	class APIKeyboardProperties {
		friend class APIMouseProperties;
		friend class APIApplicationProperties;
		friend class APICanvasProperties;

		private:
		static const int keycnt_ = 256;
		static const int pressedbit_ = 128;
		static unsigned long keybinder_[keycnt_];
		static BYTE states_[4][keycnt_];

		public:
		static void initialize();
		static void bindKeyCode();

		static void update();
		static void refresh();

		static bool get(Keyboard::Key key, Keyboard::KeyState state);
	};

	class APIMouseProperties {
		friend class APIHIDProperties;

		private:
		static bool buttonstate_[4][3];
		static ::POINT position_;
		static const int pressedbit_ = 128;

		public:
		static void initialize();

		static void update();
		static void refresh();

		static bool get(Mouse::Button button, Mouse::ButtonState state);
		static void getPosition(int &x, int &y);
		static void setPosition(int x, int y);
	};
*/

}	/*	<- namespace Psycholops 	*/

#endif
