/*
 *  psychlops_io_display.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/04/05 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#include "psychlops_io_display.h"


namespace Psychlops {

	const Display::PROPERTY_PRIMARY Display::primary = Display::PROPERTY_PRIMARY();
	const Display::PROPERTY_SECONDARY Display::secondary = Display::PROPERTY_SECONDARY();
	Display::PROPERTY_PRIMARY::operator Display() const {
		return Display::list()[0];
	}
	Display::PROPERTY_SECONDARY::operator Display() const {
		return (Display::list().size()>1) ? Display::list()[1] : Display::list()[0];
	}


	Display::Display(const Display &disp) : api_(disp.api_) {
		width = width;
		height = disp.height;
		color_depth = disp.color_depth;
		refresh_rate = disp.refresh_rate;
		name = disp.name;
		area = disp.area;
	}

	Display::~Display() {
	}

	Display& Display::operator =(const Display& disp) {
		width = width;
		height = disp.height;
		color_depth = disp.color_depth;
		refresh_rate = disp.refresh_rate;
		name = disp.name;
		area = disp.area;
		api_ = disp.api_;
		return *this;
	}



}	/*	<- namespace Psycholops 	*/
