/*
 *  psychlops_app_init.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/12/17 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */



#include "psychlops_app_init.h"
#include "../../psychlops_lib.h"
#include <Carbon/Carbon.h>

namespace Psychlops {

	bool is_initialized = false;

	void initialize() {
		if(!is_initialized) {
			randomize();
			AppState::initialize();
			HumanInterfaceDevice::initialize();
			File::initialize();
		}
		is_initialized = true;
	}

	void finalize() {
		if(is_initialized) {
			HumanInterfaceDevice::finalize();
		}
		is_initialized = false;
	}


}
