/*
 *  psychlops_g_shader_gl.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/12/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_GRAPHIC_SHADER_GL
#define HEADER_PSYCHLOPS_GRAPHIC_SHADER_GL

#include <string>
#include <map>
#include "../../../core/graphic/psychlops_graphic.h"

#define PSYCHLOPS_SHADER_PLATFORM
#include "../../../platform/psychlops_platform_selector.h"

namespace Psychlops {

	class ShaderAPI {
	protected:
		static bool field_initialized;
		static GLuint null_texture;
		static const unsigned char NULL_TEX[16];
		static void initField();
	public:
		static void initialize();

		static const char* shader_core_pix;
		static const char* shader_core_pix_bitsmono;
		static const char* shader_core_pix_bitsmono_bitshift;
		static const char* shader_core_getpix;
		static const char* shader_core_getpix_bitsmono;
		static const char* shader_core_getpix_bitsmono_bitshift;
		static const char* shader_core_pix_bitscolor;
		static const char* shader_base_funcs;
		static const char* shader_texture_funcs_platform;
		static const char* shader_texture_pix[2];
		static const char* shader_field_funcs_platform;

		GLuint fragShader;
		GLuint gl2Program;
		GLuint coordinates[2];
		GLuint size, size_log;
		GLuint texture[3];
		GLuint argv[16];

		ShaderAPI();
		void cache(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target);
		void cacheField(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target);
		void cacheTex(const std::string &orig_source, const std::vector<std::string> &vars, Drawable &target);
/*
		void drawFigure(Figure &fig, Drawable &target);
		void drawFigure(const Point &scale, Figure &fig, Drawable &target);
			void drawFiguresBegin();
			void drawFiguresEnd();
			void drawFiguresBody(const Point &scale, Figure &fig, Drawable &target);
*/
		void drawField(const Rectangle &rect, const double *argv, const int argn);
		void drawImage(Image &img, const double *argv, const int argn, Canvas &target);
		void fieldToImage(Image &target, const Rectangle &rect, const double *argv, const int argn, Canvas &media);
		void imageToImage(Image &target, Image &img, const double *argv, const int argn, Canvas &media);

	};


}	/*	<- namespace Psycholops 	*/

#endif
