﻿
using System.Windows.Media.Imaging;
namespace Psychlops
{

    public static partial class Figures
    {

		public static void drawGrating(ref Image img, int width, int height, double wavelength, double contrast, double orientation, double phase)
	    {
			double width_half = width / 2.0, height_half = height / 2.0;
            if (img==null || img.width != width || img.height != height)
                img = new Image(width, height);
            double freq = 2 * Math.PI / wavelength;
			img.field(
				(x, y) => new Color(.5 + contrast * .5 * Math.sin(phase + (Math.sin(orientation)*x-Math.cos(orientation)*y) * freq))
			);
	    }
		public static void drawGaussian(ref Image img, double sigma, double factor)
		{
			int width = (int)(sigma * 8), height = (int)(sigma * 8);
			double width_half = width / 2.0, height_half = height / 2.0;
			if (img == null || img.width != width || img.height != height)
				img = new Image(width, height);
			img.field(
				(x, y) => new Color(factor * Math.gaussian(Math.radius(x - width_half, y - height_half), width / 8.0))
			);
		}

		public static void drawGabor(ref Image img, double sigma, double frequency, double contrast, double orientation, double phase)
	    {
            int width = (int)(sigma * 8), height = (int)(sigma * 8);
			double width_half = width / 2.0, height_half = height / 2.0;
            if (img==null || img.width != width || img.height != height)
                img = new Image(width, height);
            double freq = 2 * Math.PI * frequency;
			img.field(
				(x, y) => new Color(.5 + contrast * Math.gaussian(Math.radius(x - width_half, y - height_half), width / 8.0) * .5 * Math.sin(phase + (Math.sin(orientation) * x - Math.cos(orientation) * y) * freq))
			);
	    }

    }
}
