#include <psychlops.h>
using namespace Psychlops;

void ullmancylinder() {
	const int DOTCNT = 15000;

	int dotcnt = 100;
	double bg_lum = 0.0;
	double velocity = 1.0;
	double SOA_pp;
	int SIZE = 3;
	int SOA = 1;
	double CylinderRadius=200;
	int a1=0;
	
	Range rng;
	Independent << dotcnt   | "Number of Dots" |   1< rng< DOTCNT |  10   | 1000 ;
	Independent << velocity | "Dot Velocity"   | 0.0<=rng<=10.0   |  0.1 | 0.05;
	Independent << SOA      | "SOA Frames"     |   1.0<=rng<=60.0     |  1   | 1;
	Independent << bg_lum   | "Luminance Inv." | 0.0<=rng<=1.0    |  1   | 1;
	Independent << SIZE     | "Dot Size"       |   0< rng<=10    |  1   | 1;
	Independent << CylinderRadius|  "Cylinder Size"  |  0< rng<= 400   |  1   | 50;


	Canvas canvas(Canvas::fullscreen);
	Psychlops::Rectangle rect(SIZE,SIZE);
	Psychlops::Color bgcolor(0), dotcolor(1.0-bg_lum);

	double phase=0.0;
	double x[DOTCNT], dx[DOTCNT], y[DOTCNT];

	for(int i=0; i<DOTCNT; i++) {
		x[i] = Psychlops::random(CylinderRadius*2*PI);
		y[i] = Psychlops::random(CylinderRadius*2)+200;
	}
	Display::watchFPS();
	while(!Input::get(Keyboard::spc)) {
		bgcolor.set(bg_lum);
		dotcolor.set(1.0-bg_lum);
		canvas.clear(bgcolor);
		rect.resize(SIZE,SIZE);

		phase += velocity;	
		SOA_pp =SOA+1;

		for(int i=0; i<DOTCNT; i++)	dx[i] = (int)(CylinderRadius*sin(x[i]+SOA_pp*phase/100.0))+canvas.getHcenter();//ehbgʒǔvZ
		for(int i=0; i<dotcnt; i++)	rect.centering(dx[i], y[i]).draw(dotcolor);
		//t[Ԃ܂
		a1=Display::lastFailedFrames();
		if(a1)Display::clear(Color(0.25,0.25,0.25));
		Display::showFPS();
		canvas.flip(SOA);
	}
}


void psychlops_main()
{

	Procedure p;
	p.setDesign(Procedure::DEMO);
	p.setProcedure(ullmancylinder);
	p.run();

}