/*
 *  psychlops_io_file_Win32.cpp
 *  Psychlops Standard Library (Win32)
 *
 *  Last Modified 2006/01/05 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include <string>
#include <windows.h>

#include "../../core/ApplicationInterfaces/psychlops_app.h"
#include "../../core/devices/psychlops_io_file.h"


namespace Psychlops {

	const char File::PATH_DEVIDER = '\\';

	void File::initialize() {
		unsigned int loc;
		char * apppath = new char[1024];
		for(int i=0; i<1024; i++) apppath[i] = 0;
		GetModuleFileName(NULL, apppath, 1024);
		STANDARD_PATH[PATH_APP].path = apppath;
		loc = STANDARD_PATH[PATH_APP].path.find_last_of('\\');
		STANDARD_PATH[PATH_APP].path.erase(loc+1);
		STANDARD_PATH[PATH_RSC].path = STANDARD_PATH[PATH_APP].path + "Resources\\";
		GetEnvironmentVariable("USERPROFILE", apppath, 1024);
		STANDARD_PATH[PATH_HOME].path = apppath;
		STANDARD_PATH[PATH_HOME].path += "\\";
		GetEnvironmentVariable("APPDATA", apppath, 1024);
		STANDARD_PATH[PATH_SETTING].path = apppath;
		STANDARD_PATH[PATH_SETTING].path += "\\";
		delete [] apppath;

		BYTE * documentspath = new BYTE[1024];
		for(int i=0; i<1024; i++) documentspath[i] = 0;
		HKEY phk;
		unsigned long lpReserved = 0, lpcbData = 1024;
		LONG err = RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", 0, KEY_QUERY_VALUE, &phk);
		if(err!=0) Exception(typeid(File), "", "Failed to get user home path.");;
		RegQueryValueEx(phk, "Personal", NULL, NULL, documentspath, &lpcbData);
		RegCloseKey(phk);
		STANDARD_PATH[PATH_DOCUMENTS_ROOT].path.assign(reinterpret_cast<char *>(documentspath));
		STANDARD_PATH[PATH_DOCUMENTS_ROOT].path += "\\";
		delete [] documentspath;

		initialize_appname();
	}

	void File::initialize_appname() {
		if(!appname_initialized) {
			STANDARD_PATH[PATH_SETTING].path += AppInfo::appname + '\\';
			STANDARD_PATH[PATH_DOCUMENTS].path = STANDARD_PATH[PATH_DOCUMENTS_ROOT].path + AppInfo::appname + '\\';
			//if(AppInfo::appname=="Psychlops" && AppInfo::expname!="") {
			//	STANDARD_PATH[PATH_SETTING].path += AppInfo::expname + '\\';
			//	STANDARD_PATH[PATH_DOCUMENTS].path += AppInfo::expname + '\\';
			//}
			appname_initialized = true;
		}
	}

	std::string File::getCurrentDirectory() {
		TCHAR current_directory_path[1024];
		if(GetCurrentDirectory(1024, current_directory_path)==0) {
				throw Exception(typeid(File), "", "Failed to get current directory.");
		}
		return std::string(current_directory_path);
	}

	void File::setCurrentDirectory(const std::string &path, bool force_mkdir) {
		if(SetCurrentDirectory(path.c_str())==0) {
			if(force_mkdir) {
				CreateDirectory(path.c_str(), NULL);
				SetCurrentDirectory(path.c_str());
			} else {
				throw Exception(typeid(File), "", "Failed to set current directory to requested path.");
			}
		}
	}

	void File::setCurrentDirectoryDefault() {
		setCurrentDirectory(STANDARD_PATH[PATH_APP].path, false);
	}

	std::string File::replacePathDevider(const std::string &path) {
		std::string decoded_path = path;
		unsigned int found, restart=0;
		for(;;) {
			found=decoded_path.find('/',restart);
			if(found==std::string::npos) { break; }
			decoded_path.replace(found, 1, 1, PATH_DEVIDER);
			restart = found;
		}
		return decoded_path;
	}

}	/*	<- namespace Psycholops 	*/
