/*
 *  psychlops_app_init_Win32.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/12/19 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#include "../../core/ApplicationInterfaces/psychlops_app_init.h"
#include "psychlops_app_state_Win32.h"
#include "../../psychlops_core.h"


namespace Psychlops {

	bool is_initialized = false;

	void initialize() {
		if(!is_initialized) {
			randomize();
			APIApplicationProperties::startupinfo.initialize();
			Clock::initialize();
			HumanInterfaceDevice::initialize();
			File::initialize();
		}
		is_initialized = true;
	}

	void finalize() {
		if(is_initialized) {
			HumanInterfaceDevice::finalize();
		}
		is_initialized = false;
	}

}

