#include <iostream>
#include <psychlops.h>
using namespace Psychlops;

void psychlops_main() {
	Canvas cnvs(1024,700,Canvas::window);
//	cnvs.watchFPS();
//	cnvs.showFPS();
	Mouse::show();



	Color::setGammaValue(1.0,1.0,1.0);


	Image buf[10], reference[10], difference[10], difference2[10];

	Figures::ShaderGrating grat;
	Figures::ShaderExponentialDot dot;
	Figures::ShaderGabor gabor;
	//std::ofstream f("shader_prec_test.txt");


	double c=1, w=48, o=-40, p=0;
	Widgets::Dial dial[4];
	dial[0].link(c, 2);
	dial[1].link(w, 36);
	dial[2].link(o, 360);
	dial[3].link(p, 960);

	//for(double o=0; o<PI; o+=PI/8) {
	//for(double w=4; w<128; w*=2) {
	//for(double c=0.25; c<=1.0; c+=0.25) {
	REDRAW:

		gabor.setSigma(30);
		gabor.contrast = c;
		gabor.wavelength = w;
		gabor.phase = p/360.0*2*PI;
		gabor.orientation = o/360.0*2*PI;
		gabor.to(buf[0]);

		grat.set(240,240);
		grat.contrast = c;
		grat.wavelength = w;
		grat.phase = p/360.0*2*PI;
		grat.orientation = o/360.0*2*PI;
		grat.to(buf[1]);

		dot.setSigma(30);
		dot.factor = 1;
//		dot.to(buf[2]);


		Figures::drawGaborToImage(reference[0], 30, 1.0/w, c, o/360.0*2*PI, p/360.0*2*PI);
		Figures::drawGratingToImage(reference[1], 240,240 , 1.0/w, c, o/360.0*2*PI, p/360.0*2*PI);
//		Figures::drawExponentialToImage(reference[2], 30, 1);

		cnvs.clear(Color(0.25));
		cnvs.msg(L"シェーダ　　　　　　　　　-　　　　　　　　　CPU　　　　　　　　　=　　　　　　　　　誤差（赤：誤差2以上）", 100, 40, Color::white);
		for(int i=0; i<2; i++) {
			//f << c << "\t" << w << "\t" << o/2.0/PI*360.0 << "\t";
			//f <<
				Figures::substructImages(difference[i], buf[i], reference[i], 255.0)
			//<< "\t"
			;
			buf[i].centering(170,170+i*300).draw();
			reference[i].centering(470,170+i*300).draw();
			difference[i].centering(770,170+i*300).draw();
		}
		//f << std::endl;

	/*
		const int DIFF = 2, SLINE = 120;
		difference2[DIFF].set(480,512);
		int y1, y2;
		for(int y=0; y<240; y++) {
			y1 = (int)(512-reference[DIFF].getPix(SLINE,y).getR()*512);
			y2 = (int)(512-buf[DIFF].getPix(SLINE,y).getR()*512);
			difference2[DIFF].rect(Psychlops::Rectangle(y*2, y1, y*2+1, 511), Color(0.4));
			if(y1>y2) difference2[DIFF].rect(Psychlops::Rectangle(y*2, y2, y*2+1, y1), Color::green);
			if(y1<y2) difference2[DIFF].rect(Psychlops::Rectangle(y*2, y1, y*2+1, y2), Color::red);
		}
		difference2[DIFF].centering().draw();
	*/

	//	cnvs.flip();
	//	if(Keyboard::esc.pushed()) { exit(0); }
	//}
	//}
	//}


	while(!Keyboard::esc.pushed()) {
		cnvs.clear(Color(0.25));
		cnvs.msg(L"シェーダ　　　　　　　　　-　　　　　　　　　CPU　　　　　　　　　=　　　　　　　　　誤差（赤：誤差2以上）", 200, 40, Color::white);
		for(int i=0; i<2; i++) {
			buf[i].centering(270,170+i*300).draw();
			reference[i].centering(570,170+i*300).draw();
			difference[i].centering(870,170+i*300).draw();
		}
		for(int i=0; i<4; i++) dial[i].set(50).centering(50,100+i*50).draw();
		if(dial[0].changed() || dial[1].changed() || dial[2].changed() || dial[3].changed()) goto REDRAW;
		cnvs.msg(L"ピクセルの位相に鋭敏　コントラストに不変　→　π（無理数）の有効桁数の問題", 200, 640, Color::white);
		cnvs.msg(L"コントラストに鋭敏　→　8 bit変換時の丸めがISO丸めか四捨五入か", 200, 680, Color::white);
		cnvs.flip();
	}
}

