/*
 *  psychlops_io_clock.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2005/12/19 by Kenchi HOSOKAWA
 *  (C) 2005 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_DEVICES_CLOCK
#define HEADER_PSYCHLOPS_DEVICES_CLOCK

#define PSYCHLOPS_CLOCK_API_PLATFORM
#include "../../platform/psychlops_platform_selector.h"
#undef PSYCHLOPS_CLOCK_API_PLATFORM


namespace Psychlops {


	class Clock {
		private:
		CLOCK_UNIT clock_;
		static CLOCK_UNIT clocks_per_a_milisecond_;
		int frame_;
		bool is_just_;
		Clock(CLOCK_UNIT native_clock);

		public:
		static void initialize();
		Clock();
		~Clock();
		void update();
//		Clock operator -();
		Clock operator +(Clock &rhs);
		Clock operator -(Clock &rhs);
		//Clock operator *(double &rhs);
		//Clock operator /(double &rhs);
		//Clock operator %(double &rhs);
		Clock & operator +=(Clock &rhs);
		Clock & operator -=(Clock &rhs);
		//Clock & operator *=(double &rhs);
		//Clock & operator /=(double &rhs);
		bool operator ==(Clock &rhs);
		bool operator !=(Clock &rhs);
		bool operator >(Clock &rhs);
		bool operator <(Clock &rhs);
		bool operator >=(Clock &rhs);
		bool operator <=(Clock &rhs);
		double at_msec();
	};

	long Gettime_ms();  // obsolete


}	/*	<- namespace Psycholops 	*/


#endif
