/*
 *  psychlops_io_analog.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2008/04/05 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#include "psychlops_io_analog.h"


namespace Psychlops {

	ITrigger::~ITrigger() {
	}


	const Exception trg_no_inst("Trigger has no instance.");
	Trigger::Trigger() { instance = 0; }
	Trigger::Trigger(ITrigger *v) { instance = v; }
	Trigger::Trigger(ITrigger &v) { instance = &v; }
	void Trigger::set(ITrigger *v) { instance = v; }
	void Trigger::set(ITrigger &v) { instance = &v; }
	Trigger::~Trigger() { if(instance==0) delete instance; }

	void Trigger::trigger() { if(instance!=0) instance->trigger(); else throw trg_no_inst; }



	AnalogInput::~AnalogInput() {
	}

	AnalogOutput::~AnalogOutput() {
	}


}	/*	<- namespace Psycholops 	*/
