/*
 *  psychlops_app_thread.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 208/09/22 by Kenchi HOSOKAWA
 *  (C) 2008 Kenchi HOSOKAWA, Kazushi MARUYA, Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_APP_THREAD
#define HEADER_PSYCHLOPS_APP_THREAD



namespace Psychlops {

namespace Prototype {

	class Thread {
	protected:
		char memory[32];
	public:
		enum Priority { HIGH=0, NORMAL, LOW, IDLE, SLEEP };
		
		Thread();
		Thread(void (*func)());
		virtual ~Thread();
		virtual void create(void (*func)());
		static void yield();
		static void sleep(int microsec);
		static Priority priority();
		static void priority(Priority p);

	};
}

}	/*	<- namespace Psychlops 	*/


#endif
