#include <psychlops.h>
using namespace Psychlops;

void psychlops_main() {
	//	Canvas cnvs(800,600,Canvas::window);
	Canvas cnvs(Canvas::fullscreen, Display::secondary);
	cnvs.watchFPS();
	cnvs.showFPS();
//	Mouse::show();

	const int N = 2500;
	Figures::ShaderPlaid *plaid;
	plaid = new Figures::ShaderPlaid[N];
	for(int y=0; y<N; y++) {
		plaid[y].phase = random(2*PI);
		plaid[y].contrast = random(0.5);
		plaid[y].wavelength = 5+random(10.0);
		plaid[y].phase2 = random(2*PI);
		plaid[y].contrast2 = random(0.5);
		plaid[y].wavelength2 = 10+random(20.0);
	}

	double sigma = 6.0;
	int n = 300.0;
	Widgets::Dial dial;
	dial.link(sigma, 2).set(50).shift(100,100);
	Widgets::Slider slider;
	slider.link(n, Interval(0,2500), 4).set(200, 30);//.centering();
	Rectangle mouse_cur(10,10);

	while(!Keyboard::esc.pushed()) {
		cnvs.clear(Color::gray);
		//dial.draw();
		slider.draw();
		if(slider.changed()) for(int i=0; i<n; i++) plaid[i].centering(Psychlops::random(cnvs.getWidth()), Psychlops::random(cnvs.getHeight()));
		for(int i=0; i<n; i++) {
			plaid[i].resize(sigma*8, sigma*8);
			plaid[i].phase += PI/6;
			plaid[i].wavelength = plaid[i].wavelength + .5*sin(plaid[i].phase);
			plaid[i].orientation = -atan2(plaid[i].getCenter().x-cnvs.mouse().x, plaid[i].getCenter().y-cnvs.mouse().y);
			plaid[i].phase2 += PI/6;
			plaid[i].wavelength2 = plaid[i].wavelength2 + .5*sin(plaid[i].phase2);
			plaid[i].orientation2 = PI/2-atan2(plaid[i].getCenter().x-cnvs.mouse().x, plaid[i].getCenter().y-cnvs.mouse().y);
			plaid[i].draw();
		}
		//cnvs.var(sigma*8, dial.getDatum().x, dial.getDatum().y);
		//cnvs.var(n, slider.getDatum().x, slider.getDatum().y);
		//cnvs.var(pow(floor(sigma*8), 2)*n, 200, 50, Color::green);
		mouse_cur.centering(cnvs.mouse()).draw(Color::red);
		cnvs.flip();
	}
	delete [] plaid;
}

