/*
 *  psychlops_g_shader_Win32GL.cpp
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2009/12/14 by Kenchi HOSOKAWA
 *  (C) 2009 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */


#include "../../../core/ApplicationInterfaces/psychlops_code_exception.h"
#define PSYCHLOPS_SHADER_PLATFORM
#include "../../../platform/psychlops_platform_selector.h"

#include "../../../platform/gl/extension/psychlops_g_shader_gl.h"

namespace Psychlops {

/*
	const char* ShaderAPI::shader_field_funcs_platform =
	"const vec2 field_origin2 = vec2(0.0,0.0);"
	"uniform float RECT_WIDTH, RECT_HEIGHT;"
	"float xi()   { return gl_TexCoord[0][0]/2.0; }"
	"float yi()   { return gl_TexCoord[0][1]/2.0; }"
	"float xp()   { return gl_TexCoord[0][0]*RECT_WIDTH/2.0; }"
	"float yp()   { return gl_TexCoord[0][1]*RECT_HEIGHT/2.0; }"
	"float xf()   { return gl_TexCoord[0][0]-1.0; }"
	"float yf()   { return gl_TexCoord[0][1]-1.0; }"
	"float rf()     { return distance(vec2(xf(), yf()), field_origin2); }"
	"float thetaf() { return atan(yf(), xf()); }"
	;
	
	const char* ShaderAPI::shader_texture_funcs_platform =
	"const vec2 field_origin2 = vec2(0.0,0.0);"
	"uniform float RECT_WIDTH, RECT_HEIGHT;"
	"float xi()   { return gl_TexCoord[0][0]/RECT_WIDTH; }"
	"float yi()   { return gl_TexCoord[0][1]/RECT_HEIGHT; }"
	"float xp()   { return gl_TexCoord[0][0]; }"
	"float yp()   { return gl_TexCoord[0][1]; }"
	"float xf()   { return ((gl_TexCoord[0][0]/RECT_WIDTH-0.5)*2.0); }"
	"float yf()   { return ((gl_TexCoord[0][1]/RECT_HEIGHT-0.5)*2.0); }"
	"float rf()     { return distance(vec2(xf(), yf()), field_origin2); }"
	"float thetaf() { return atan(yf(), xf()); }"
	"uniform sampler2D texture0;"
	"vec4 getPix() { return texture2DProj(texture0, gl_TexCoord[0]); }"
	"vec4 getPix(const in int x, const in int y) { return texture2DProj(texture0, gl_TexCoord[0]+vec4(float(x)/RECT_WIDTH,float(-y)/RECT_HEIGHT,0,0)); }"
	;
*/

	bool global_initialized = false;
	ShaderAPI::ShaderAPI()
	{
	}
	void ShaderAPI::initialize()
	{
		if(!global_initialized)
		{
#if defined(PANTHER)
			if(glewInit()) throw new Exception("This system does not support shader although　this program requires it.");
#endif
			global_initialized = true;
		}
	}

}	/*	<- namespace Psycholops 	*/
