/*
 *  psychlops_io_analog.h
 *  Psychlops Standard Library (Universal)
 *
 *  Last Modified 2008/10/05 by Kenchi HOSOKAWA
 *  (C) 2006 Kenchi HOSOKAWA, Kazushi MARUYA and Takao SATO
 */

#ifndef HEADER_PSYCHLOPS_IO_ANALOG
#define HEADER_PSYCHLOPS_IO_ANALOG

#include "../math/psychlops_math.h"

namespace Psychlops {

	class ITrigger
	{
		public:
		virtual ~ITrigger();
		virtual void trigger() = 0;
	};

	class Trigger : public ITrigger
	{
		private:
		ITrigger *instance;

		public:
		Trigger();
		Trigger(ITrigger *);
		Trigger(ITrigger &);
		void set(ITrigger *);
		void set(ITrigger &);
		virtual ~Trigger();

		virtual void trigger();
	};


	class AnalogInput {
		public:
		double (*normalize)(double);
		virtual ~AnalogInput();
		virtual double get() = 0;
//		virtual setNormalize(double (*fn)(double)) = 0;
	};

	class AnalogOutput {
		public:
		double (*denormalize)(double);
		virtual ~AnalogOutput();
		virtual void put(double) = 0;
//		virtual denormalize(double) = 0;
	};

}	/*	<- namespace Psycholops 	*/

#endif
