#include "common.h"
#include "decompres.h"
#include "decrypt.h"
#include "key.c"



#define	PRX1_BUF1_SIZE	0x150

#define	PRX1_B00_OFS	0x00
#define	PRX1_B80_OFS	0x80
#define	PRX1_BB0_OFS	0xB0
#define	PRX1_BD0_OFS	0xD0

#define	PRX1_B00_SIZE	0x80
#define	PRX1_B80_SIZE	0x50
#define	PRX1_BB0_SIZE	0x20
#define	PRX1_BD0_SIZE	0x80


#define	PRX2_TMP1_SIZE	0x150
#define	PRX2_TMP2_SIZE	0x90
#define	PRX2_TMP3_SIZE	0x60


#define	IPL_BLOCK_SIZE	0x1000



int KIRK(u32 *buf, int size, u32 code, u32 type, int cmd)
{
	int ret = 0;

	buf[0]	= type;
	buf[1]	= buf[2] = 0;
	buf[3]	= code;
	buf[4]	= size;
	
	if (ku_sceUtilsBufferCopyWithRange(buf, size+0x14, buf, size+0x14, cmd) != 0) ret = -1;

	return 0;
}





static void* GetTagInfo( u32 tag )
{
	int i;

	for (i = 0; i < sizeof(g_tagInfo)/sizeof(TAG_INFO); i++)
	{
        if (g_tagInfo[i].tag == tag)
		{
			return (void*)&g_tagInfo[i];
		}
	}
	
	for (i = 0; i < sizeof(g_tagInfo2) / sizeof(TAG_INFO2); i++)
	{
		if (g_tagInfo2[i].tag == tag)
		{
			return (void*)&g_tagInfo2[i];
		}
	}

	return NULL;
}

static int DecryptPRX1(const u8* pbIn, u8* pbOut, int cbTotal, u32 tag)
{
	int i,  retsize ,iXOR;
	u8 buffer1[PRX1_BUF1_SIZE],bD0[PRX1_BD0_SIZE], b80[PRX1_B80_SIZE], b00[PRX1_B00_SIZE], bB0[PRX1_BB0_SIZE];
	TAG_INFO const* pti = (TAG_INFO*)GetTagInfo(tag);
	
	static u8 g_dataTmp[0x14+0xA0] __attribute__((aligned(0x40)));		

	if (pti == NULL) return -1;
	
	retsize = *(u32*)&pbIn[OFS_FILE_SIZE];
	
	for (i = 0; i < 0x14; i++)
	{
		if (pti->key[i] != 0) break;
	}
	
	if (i == 0x14)
	{
		//܂KeyÍԂXNu
		KIRK_Scramble((u32 *)pti->key, 0x90, pti->code);
	}
	
	// build conversion into pbOut
	
	if (pbIn != pbOut)
	{
		memcpy(pbOut, pbIn, cbTotal);
	}
	
	memcpy(bD0, pbIn+PRX1_BD0_OFS, PRX1_BD0_SIZE);
	memcpy(b80, pbIn+PRX1_B80_OFS, PRX1_B80_SIZE);
	memcpy(b00, pbIn+PRX1_B00_OFS, PRX1_B00_SIZE);
	memcpy(bB0, pbIn+PRX1_BB0_OFS, PRX1_BB0_SIZE);
	
	memset(pbOut, 0, PRX1_BUF1_SIZE);
	memset(pbOut, 0x55, 0x40); // first $40 bytes ignored
	
	// step3 demangle in place
	
	// redo part of the SIG check (step2)
	
	memcpy(buffer1+PRX1_B00_OFS, bD0, PRX1_B00_SIZE);
	memcpy(buffer1+PRX1_B80_OFS, b80, PRX1_B80_SIZE);
	memcpy(buffer1+PRX1_BD0_OFS, b00, PRX1_BD0_SIZE);
	
	if (pti->codeExtra != 0)
	{
		//ExtraV2Mangle
		memcpy(g_dataTmp+0x14, buffer1+0x10, 0xA0);
		
		/*if (KIRK_Scramble((u32*)g_dataTmp,0xA0,pti->codeExtra) != 0) Kprintf("extra de-mangle returns err\n");*/
		KIRK_Scramble((u32*)g_dataTmp,0xA0,pti->codeExtra);
		
		// copy result back
		memcpy(buffer1+0x10, g_dataTmp, 0xA0);
	}
	
	memcpy(pbOut+0x40 /* 0x2C+0x14 */, buffer1+0x40, 0x40);
	
	for (iXOR = 0; iXOR < 0x70; iXOR++)
	{
		pbOut[0x40+iXOR] = pbOut[0x40+iXOR] ^ pti->key[0x14+iXOR];
	}
	
	if (KIRK_Scramble((u32*)(pbOut+0x2C),0x70,pti->code) != 0)
	{
		//Kprintf("mangle#7 returned err\n");
		return -1;
	}
	
	for (iXOR = 0x6F; iXOR >= 0; iXOR--)
	{
		pbOut[0x40+iXOR] = pbOut[0x2C+iXOR] ^ pti->key[0x20+iXOR];
	}
	
	memset(pbOut+0x80, 0, 0x30); // $40 bytes kept, clean up
	pbOut[0xA0] = 1;
	
	// copy unscrambled parts from header
	memcpy(pbOut+PRX1_BB0_OFS, bB0, PRX1_BB0_SIZE); // file size + lots of zeros
	memcpy(pbOut+PRX1_BD0_OFS, b00, PRX1_BD0_SIZE); // ~PSP header
	
	// step4: do the actual decryption of code block
	//  point 0x40 bytes into the buffer to key info
	
	if (KIRK_Decrypt(pbOut, cbTotal, pbOut+0x40, cbTotal-0x40) != 0)
    {
		//Kprintf("mangle#1 returned err\n");
		return -1;
	}
	
	// return cbTotal - PRX1_BUF1_SIZE; // rounded up size
	return retsize;
}



static int DecryptPRX2(const u8 *inbuf, u8 *outbuf, u32 size, u32 tag)
{
	int i, j,iXOR,retsize;
	u8 tmp1[PRX2_TMP1_SIZE], tmp2[PRX2_TMP2_SIZE+0x14], tmp3[PRX2_TMP3_SIZE+0x14];
	TAG_INFO2 *pti = (TAG_INFO2*)GetTagInfo(tag);
	
	//Kprintf("Unknown tag 0x%08X.\n", tag);
	if (pti == NULL) return -1;
	
	retsize = *(int *)&inbuf[OFS_FILE_SIZE];
	
	memset(tmp1, 0, PRX2_TMP1_SIZE);
	memset(tmp2, 0, PRX2_TMP2_SIZE+0x14);
	memset(tmp3, 0, PRX2_TMP3_SIZE+0x14);
	
	if (inbuf != outbuf)
	{
		memcpy(outbuf, inbuf, size);
	}
	
	//Kprintf("Buffer not big enough.\n");
	if (size < 0x160) return -2;
	
	//Kprintf("Buffer not aligned to 64 bytes.\n");
	if (((u32)outbuf & 0x3F)) return -3;

	//Kprintf("No enough data.\n");
	if ((size - PRX2_TMP1_SIZE) < retsize) return -4;
	
	memcpy(tmp1, outbuf, PRX2_TMP1_SIZE);
	
	
	for (i = 0; i < 9; i++)
	{
		for (j = 0; j < 0x10; j++)
		{
			tmp2[(i << 4) + j + 0x14] = pti->key[j];
		}
		
		tmp2[(i << 4) + 0x14] = i;
	}
	
	if ( KIRK_Scramble((u32 *)tmp2, PRX2_TMP2_SIZE, pti->code) < 0 )
	{
		//Kprintf("Error in Scramble #1.\n");
		return -5;
	}
	
	memcpy(outbuf, tmp1+0xD0, 0x5C);
	memcpy(outbuf+0x5C, tmp1+0x140, 0x10);
	memcpy(outbuf+0x6C, tmp1+0x12C, 0x14);
	memcpy(outbuf+0x80, tmp1+0x080, 0x30);
	memcpy(outbuf+0xB0, tmp1+0x0C0, 0x10);
	memcpy(outbuf+0xC0, tmp1+0x0B0, 0x10);
	memcpy(outbuf+0xD0, tmp1+0x000, 0x80);
	
	memcpy(tmp3+0x14, outbuf+0x5C, PRX2_TMP3_SIZE);
	
	if ( KIRK_Scramble((u32 *)tmp3, PRX2_TMP3_SIZE, pti->code) < 0 )
	{
		//Kprintf("Error in Scramble #2.\n");
		return -6;
	}
	
	memcpy(outbuf+0x5C, tmp3, PRX2_TMP3_SIZE);
	memcpy(tmp3, outbuf+0x6C, 0x14);
	memcpy(outbuf+0x70, outbuf+0x5C, 0x10);
	memset(outbuf+0x18, 0, 0x58);
	memcpy(outbuf+0x04, outbuf, 0x04);
	
	*((u32 *)outbuf) = 0x014C;
	memcpy(outbuf+0x08, tmp2, 0x10);
	
	/* sha-1 */
	if ( KIRK_SHA1(outbuf, 3000000, outbuf, 3000000) != 0 )
	{
		//Kprintf("Error in sceUtilsBufferCopyWithRange 0xB.\n");
		return -7;
	}
	
	if (memcmp(outbuf, tmp3, 0x14) != 0)
	{
		//Kprintf("SHA-1 is incorrect.\n");
		return -8;
	}
	
	for (iXOR = 0; iXOR < 0x40; iXOR++)
	{
		tmp3[iXOR+0x14] = outbuf[iXOR+0x80] ^ tmp2[iXOR+0x10];
	}
	
	if ( KIRK_Scramble((u32 *)tmp3, 0x40, pti->code) != 0 )
	{
		//Kprintf("Error in Scramble #2.\n");
		return -9;
	}
	
	for (iXOR = 0x3F; iXOR >= 0; iXOR--)
	{
		outbuf[iXOR+0x40] = tmp3[iXOR] ^ tmp2[iXOR+0x50]; // uns 8
	}
	
	memset(outbuf+0x80, 0, 0x30);
	*(u32 *)&outbuf[0xA0] = 1;
	
	memcpy(outbuf+0xB0, outbuf+0xC0, 0x10);
	memset(outbuf+0xC0, 0, 0x10);
	
	// The real decryption
	if ( KIRK_Decrypt(outbuf, size, outbuf+0x40, size-0x40) != 0 )
	{
		//Kprintf("Error in sceUtilsBufferCopyWithRange 0x1.\n");
		return -1;
	}
	
	if (retsize < PRX2_TMP1_SIZE)
	{
		// Fill with 0
		memset(outbuf+retsize, 0, PRX2_TMP1_SIZE-retsize);		
	}
	
	return retsize;
}



int pspDecryptPRX(u8 *inbuf, u8 *outbuf, u32 size)
{
	int retsize = DecryptPRX1(inbuf, outbuf, size, *(u32 *)&inbuf[OFS_FILE_TAG]);
	
	if (retsize <= 0)
	{
		retsize = DecryptPRX2(inbuf, outbuf, size, *(u32 *)&inbuf[OFS_FILE_TAG]);
	}
	
	
	return retsize;
}


////////// IPL Decryption /////////



int pspDecryptIPL1(const u8* pbIn, u8* pbOut, int cbIn)
{
	// 0x1000 pages
	static u8 g_dataTmp[0x1040] __attribute__((aligned(0x40)));
	int cbOut = 0;
	
	while (cbIn >= IPL_BLOCK_SIZE)
	{
		memcpy(g_dataTmp+0x40, pbIn, IPL_BLOCK_SIZE);
		
       	pbIn += IPL_BLOCK_SIZE;
       	cbIn -= IPL_BLOCK_SIZE;
		
       	int ret = KIRK_Decrypt(g_dataTmp, 0x1040, g_dataTmp+0x40, 0x500);
		
		if (ret != 0)
       	{
			//Kprintf("Decrypt IPL 1 failed 0x%08X, WTF!\n", ret);
			break; // stop, save what we can
       	}
		
        memcpy(pbOut, g_dataTmp, IPL_BLOCK_SIZE);
		
       	pbOut += IPL_BLOCK_SIZE;
       	cbOut += IPL_BLOCK_SIZE;
    }
	
	
	return cbOut;
}

int pspLinearizeIPL2(const u8* pbIn, u8* pbOut, int cbIn)
{
	u32 nextAddr = 0;
	int cbOut = 0;
	
	while (cbIn > 0)
	{
       	u32* pl = (u32*)pbIn;
       	u32 addr = pl[0],count = pl[1];
        	
		if (addr != nextAddr && nextAddr != 0)
		{
			return 0;   // error
		}
		
       	nextAddr = addr + count;
		
       	memcpy(pbOut, pbIn+0x10, count);
		
		pbOut += count;
		cbOut += count;
		pbIn += IPL_BLOCK_SIZE;
		cbIn -= IPL_BLOCK_SIZE;
   	}
	
	return cbOut;
}

int pspDecryptIPL3(const u8* pbIn, u8* pbOut, int cbIn)
{
	int ret = 0;
	
	// all together now (pbIn/pbOut must be aligned)
	pbIn += 0x10000;
	cbIn -= 0x10000;
	
	memcpy(pbOut+0x40, pbIn, cbIn);

	if ( KIRK_Decrypt(pbOut, cbIn+0x40, pbOut+0x40, cbIn) == 0 )
   	{
		ret = *(u32*)&pbIn[0x70];  // true size
	}
	else
	{
		//Kprintf("mangle#1 returned $%x\n", ret);
   	}
		
	return ret;
}


////////// sign/Unsign Check //////////


int pspIsSignChecked(u8 *buf)
{
	int i, res = 0;
	
	for (i = 0; i < 0x58; i++)
	{
		if (buf[0xD4+i] != 0)
		{
			res = 1;
			break;
		}
	}
	
	return res;
}



int pspSignCheck(u8 *buf)
{
	u8 enc[0xD0+0x14];
	int iXOR;
	
	memcpy(enc+0x14, buf+0x110, 0x40);
	memcpy(enc+0x14+0x40, buf+0x80, 0x90);
	
	for (iXOR = 0; iXOR < 0xD0; iXOR++)
	{
		enc[0x14+iXOR] ^= check_keys0[iXOR&0xF];
	}
	
	if ( KIRK_SignCheck((u32 *)enc, 0xD0) != 0 )
	{
		//Kprintf("SignCheck failed.\n");
		return -1;
	}
	
	for (iXOR = 0; iXOR < 0xD0; iXOR++)
	{
		enc[0x14+iXOR] ^= check_keys1[iXOR&0xF];
	}
	
	memcpy(buf+0x80, enc+0x14, 0xD0);
	
	return 0;
}


int pspUnsignCheck(u8 *buf)
{
	u8 enc[0xD0+0x14];
	int iXOR, res;
	
	memcpy(enc+0x14, buf+0x80, 0xD0);
	
	for (iXOR = 0; iXOR < 0xD0; iXOR++)
	{
		enc[iXOR+0x14] ^= check_keys1[iXOR&0xF]; 
	}
	
	res = KIRK_UnsignCheck((u32 *)enc, 0xD0);
	
	if (res < 0)
	{
		//Kprintf("UnsignCheck failed.\n");
		return res;
	}
	
	for (iXOR = 0; iXOR < 0xD0; iXOR++)
	{
		enc[iXOR] ^= check_keys0[iXOR&0xF];
	}
	
	memcpy(buf+0x80, enc+0x40, 0x90);
	memcpy(buf+0x110, enc, 0x40);
	
	
	return 0;
}



static void GenerateSeed(void *out,  u32 c1, u32 c2)
{
	u32 i, j, val1, val2, bit_insert, r1, r2, shr, base, wpar1, wpar2;
	u32 *out32 = (u32 *)out;
	
	bit_insert = 0x80000000;
	r1 = r2 = base = 0;
	
	for (i = 0; i < 0x38; i++)
	{
		val1 = key_C[i];
		
		if (val1 & 0x20)
		{
			val2 = (1 << val1);
			val1 = 0;
		}
		else
		{
			val1 = (1 << val1);
			val2 = 0;
		}
		
		val1 = (c1 & val1);
		val2 = (c2 & val2);
		
		if ((val1 | val2))
		{
			val1 = base;
			val2 = bit_insert;
		}
		else
		{
			val1 = 0;
			val2 = 0;
		}
		
		r1 = (r1 | val1);
		r2 = (r2 | val2);
		base = (base >> 1);
		base = (base & 0x7FFFFFFF) | ((bit_insert & 1) << 31);
		bit_insert = (bit_insert >> 1);
	}
	
	wpar1 = (r2 >> 4);
	wpar2 = (r1 >> 8) & 0x00FFFFFF;
	wpar2 = (wpar2  & 0xF0FFFFFF) | ((r2 & 0xF) << 24);
	
	for (i = 0x10; i != 0; i--)
	{
		r1 = 0x7efc;
		val1 = (wpar1 << 4);
		r1 = (r1 >> i);
		val2 = (wpar2 << 4);
		r1 = (r1 & 1);
		shr = (r1 ^ 0x1F);
		r1++;
		val1 = (val1 >> shr);
		val2 = (val2 >> shr);
		wpar1 = (wpar1 << r1);
		wpar2 = (wpar2 << r1);
		wpar1 = (wpar1 | val1);
		wpar2 = (wpar2 | val2);
		wpar1 = (wpar1 & 0x0FFFFFFF);
		wpar2 = (wpar2 & 0x0FFFFFFF);
		c2 = (wpar2 >> 24);
		c2 = (c2&0xF) | ((wpar1 & 0x0FFFFFFF) << 4);
		c1 = (wpar2 << 8);
		
		base = r1 = r2 = 0;
		bit_insert = 0x80000000;
		
		for (j = 0; j < 0x30; j++)
		{
			val1 = key_Z[j];
			
			if (val1 & 0x20)
			{
				val2 = (1 << val1);
				val1 = 0;
			}
			else
			{
				val1 = (1 << val1);
				val2 = 0;
			}
			
			val1 = (c1 & val1);
			val2 = (c2 & val2);
			
			if ((val1 |val2))
			{
				val1 = base;
				val2 = bit_insert;
			}
			else
			{
				val1 = 0;
				val2 = 0;
			}
			
			r1 = (r1 | val1);
			r2 = (r2 | val2);
			base = (base >> 1);
			base = (base & 0x7FFFFFFF) | ((bit_insert & 1) << 31);
			bit_insert = (bit_insert >> 1);
		}
		
		out32[0] = r1;
		out32[1] = r2;
		out32 += 2;
	}
}

static void Sce_Insanity_1(u32 x1, u32 x2, u32 *r1, u32 *r2)
{
	u32 temp = ((x2 >> 4) ^ x1) & 0x0F0F0F0F;

	x2		= x2 ^ (temp << 4);
	x1		= x1 ^ temp;
	temp	= ((x2 >> 16) ^ x1) & 0xFFFF;
	x1		= x1 ^ temp;
	x2		= x2 ^ (temp << 16);
	temp	= ((x1 >> 2) ^ x2) & 0x33333333;
	x1		= x1 ^ (temp << 2);
	x2		= x2 ^ temp;
	temp	= ((x1 >> 8) ^ x2) & 0x00FF00FF;
	x2		= (x2 ^ temp);
	x1		= x1 ^ (temp << 8);
	temp	= ((x2 >> 1) ^ x1) & 0x55555555;
	*r2		= x2 ^ (temp << 1);
	*r1		= x1 ^ temp;
}

static void Sce_Insanity_2(u32 x1, u32 x2, u32 *r1, u32 *r2)
{
	u32 h1, h2, h3, h4;
	
	h1	= (x2 & 1);
	h2	= (x2 >> 27) & 0x1F;
	h3	= (x2 >> 23) & 0x3F;
	h4	= (x2 >> 19) & 0x3F;
	*r2	= (x2 >> 15) & 0x3F;
	*r2 = (*r2 & 0xFF7FFFFF) | ((h1 & 1) << 23);
	*r2 = (*r2 & 0xFF83FFFF) | ((h2 & 0x1F) << 18);
	*r2 = (*r2 & 0xFFFC0FFF) | ((h3 & 0x3F) << 12);
	*r2 = (*r2 & 0xFFFFF03F) | ((h4 & 0x3F) << 6);
	h1	= (x2 >> 11) & 0x3F;
	h2	= (x2 >> 7) & 0x3F;
	h3	= (x2 >> 3) & 0x3F;
	h4	= (x2 & 0x1F);
	*r1 = (x2 >> 31) & 1;
	*r1 = (*r1 & 0xFF03FFFF) | ((h1 & 0x3F) << 18);
	*r1 = (*r1 & 0xFFFC0FFF) | ((h2 & 0x3F) << 12);
	*r1 = (*r1 & 0xFFFFF03F) | ((h3 & 0x3F) << 6);
	*r1 = (*r1 & 0xFFFFFFC1) | ((h4 & 0x1F) << 1);
	
	*r2 = ((*r2 << 8) | ((*r1 >> 16) & 0xFF));
	*r1 = (*r1 << 16);
}

static void Sce_Insanity_3(u32 x1, u32 x2, u32 *r1, u32 *r2)
{
	int i;
	u32 shifter = 0, val;
	u8 *p = key_M;
	
	*r2 = 0;
	
	for (i = 0; i < 8; i++)
	{
		val = p[x1&0x3F];
		p += 0x40;
		x1 = (x1 >> 6);
		x1 = (x1 & 0x03FFFFFF) | ((x2 & 0x3F) << 26);
		x2 = (x2 >> 6);
		*r2 |= (val << shifter);
		shifter += 4;
	}
	
	*r1 = 0;
}

static void Sce_Insanity_4(u32 x1, u32 x2, u32 *r1, u32 *r2)
{
	int i;
	u32 *table = (u32 *)table_40;
	
	*r1 = 0;
	*r2 = 0;
	
	for (i = 0; i < 0x20; i++)
	{
		if (x2 & 1)
		{
			*r2 |= table[i];
		}
		
		x2 = (x2 >> 1);
	}
}

static void Sce_Insanity_5(u32 x1, u32 x2, u32 *r1, u32 *r2)
{
	u32 temp	= ((x2 >> 1) ^ x1) & 0x55555555;
	x1		= x1 ^ temp;
	x2		= x2 ^ (temp << 1);
	temp	= ((x1 >> 8) ^ x2) & 0x00FF00FF;
	x1		= x1 ^ (temp << 8);
	x2		= x2 ^ temp;
	temp	= ((x1 >> 2) ^ x2) & 0x33333333;
	x2		= x2 ^ temp;
	x1		= x1 ^ (temp << 2);
	temp	= ((x2 >> 16) ^ x1) & 0xFFFF;
	x2		= x2 ^ (temp << 16);
	x1		= x1 ^ temp;
	temp	= ((x2 >> 4) ^ x1) & 0x0F0F0F0F;
	*r1		= x1 ^ temp;
	*r2		= x2 ^ (temp << 4);
}

static void Sce_Paranoia(u8 *buf, u32 unused, u32 *p1, u32 *p2)
{
	u32 x1 = *p1;
	u32 x2 = *p2;
	u8 *p = buf+0x78;
	u32 r1, r2, rot1, rot2, rot3, rot4, ro1, ro2, base;
	int i;

	Sce_Insanity_1(x1, x2, &r1, &r2);
	
	rot1 = 0;
	rot2 = 0;
	rot3 = r1;
	rot4 = r2;
	
	for (i = 0; i < 0x10; i++)
	{
		Sce_Insanity_2(rot1, rot3, &r1, &r2);
		
		ro1 = r1;
		ro2 = r2;
		r1 = *(u32 *)&p[0];
		r2 = *(u32 *)&p[4];
		p -= 8;
		base = (ro2 ^ r2);
		x1 = (base << 16);
		
		Sce_Insanity_3(((ro1 ^ r1) >> 16) | x1, base >> 16, &r1, &r2);
		Sce_Insanity_4(r1, r2, &r1, &r2);
		
		x1 = (r1 ^ rot2);
		x2 = (r2 ^ rot4);
		rot2 = rot1;
		rot4 = rot3;
		rot1 = x1;
		rot3 = x2;
	}
	
	Sce_Insanity_5(x1 | rot4, x2, p1, p2);
}



static void DecryptT(u8 *buf, int size, int mode)
{
	u8 m1[0x400];
	u8 m2[8];
	int i, j;
	
	memset(m1, 0, sizeof(m1));
	
	GenerateSeed(m1,  table_keys[mode].mklow, table_keys[mode].mkhigh);
	
	memcpy(m1+0x80, table_keys[mode].key_S, 8);
	
	for (i = 0; i < size; i++)
	{
		for (j = 0; j < 8; j++)
		{
			m2[7-j] = buf[j];
		}
		
		Sce_Paranoia(m1, 0x33333333, (u32 *)&m2[0], (u32 *)&m2[4]);
		
		for (j = 0; j < 8; j++)
		{
			m1[0x90+j] = m2[7-j] ^ m1[0x80+j];
			m1[0x80+j] = buf[j];
		}
		
		*(u32 *)&buf[0] = *(u32 *)&m1[0x90];
		*(u32 *)&buf[4] = *(u32 *)&m1[0x94];
		
		buf += 8;
	}
}



int pspDecryptTable(u8 *buf1, u8 *buf2, int size, int mode)
{
	int retsize;
	
	DecryptT(buf1, size >> 3, mode);
	
	memcpy(buf2, buf1, size);
	
	if ((*(u32 *)&buf2[OFS_FILE_TAG]) == 0xD82310F0)
	{
		retsize = DecryptPRX2(buf2, buf1, size, 0xD82310F0);
	}
	else if ((*(u32 *)&buf2[OFS_FILE_TAG]) == 0xD8231EF0)
	{
		retsize = DecryptPRX2(buf2, buf1, size, 0xD8231EF0);
	}
	else
	{
		if (ku_sceMesgd_driver_102DC8AF(buf1, size, &retsize) < 0)
		{
			retsize = -1;
		}
	}
	
	return retsize;
}


int DecryptReboot(u8 *loadexec,int loadexec_size, u8* out,int out_size)
{
	int s = 0;

	//obt@TCYȂ
	if( loadexec_size > out_size ) return -3;

	memcpy(out,loadexec,loadexec_size);

	// loadexec.prx ̏ԃ`FbN
	if( *((u32*)out) == SIGNATURE_PSP )
	{
		if( pspIsSignChecked(out) )
		{
			pspUnsignCheck(out);
		}

		//Reboot.bin𒊏o邽߂ loadexec.prx  Decrypt
		s = pspDecryptPRX( out, loadexec,(u32)loadexec_size);

		if (s <= 0) return -1;

		s = pspDecompress(loadexec,out, out_size);

		if (s <= 0) return -2;
	}

	//Reboot.bin i[ĂAhX擾
	int pos = *(u32*)(out + 0x58);

	//Reboot.bin ݂邩ǂ
	if( *((u32*)(out + pos)) != SIGNATURE_PSP ) return -4;

	//Reboot.bin ̃TCY擾
	s = *((u32*)(out + pos + 0x2C));

	s = pspDecryptPRX(out + pos,loadexec, s);

	if (s <= 0) return -5;

	s = pspDecompress(loadexec, out, out_size);

	if (s <= 0) return -6;

	return s;
}