// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ArrayNode.cs 263 2010-01-16 13:12:35Z panacoran $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// z𐶐m[h\NXB
	/// </summary>
	public class ArrayNode : Node
	{
		/// <summary>
		/// z̃TCYƂȂm[h
		/// </summary>
		private Node node;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
            Token = Scanner.Token;
			Scanner.Scan();
			node = new ExpressionNode().Parse();
			if (Scanner.Token.Value != "]")
				throw new ParseException("']' expected", Scanner.Token);
            Scanner.Scan();
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			Value val = node.Execute(resource, at);
			if(val == null || val.ValueType != Value.Type.Int)
				throw new RuntimeException("invalid array size.", Token);
			return new Value(new Value[(int)val.InnerValue]);
		}
	}
}
