﻿// Copyright(C) 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: DataConvertDialog.cs 389 2010-11-28 06:45:45Z panacoran $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Protra.Lib.Dialogs
{
    /// <summary>
    /// 株価データの変換を指示するダイアログボックスです。
    /// </summary>
    public partial class DataConvertDialog : Form
    {
        /// <summary>
        /// CSV形式に変換するかどうかを取得または設定する。
        /// </summary>
        public bool ToCSV { get; set; }

        /// <summary>
        /// 変換を開始する銘柄コードを取得または設定する。
        /// </summary>
        public string StartCode { get; set; }

        /// <summary>
        /// 変換を終了する銘柄コードを取得または設定する。
        /// </summary>
        public string EndCode { get; set; }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public DataConvertDialog()
        {
            InitializeComponent();
        }

        private void buttonConvert_Click(object sender, EventArgs e)
        {
            ToCSV = radioButtonCSV.Checked;
            StartCode = numericUpDownCode1.Value.ToString();
            EndCode = numericUpDownCode2.Value.ToString();
            if (StartCode.CompareTo(EndCode) > 0)
            {
                MessageBox.Show("銘柄コードの指定が不正です。", "エラー", MessageBoxButtons.OK);
                return;
            }
            DialogResult = DialogResult.OK;
        }
    }
}
