// Copyright(C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright(C) 2004-2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MainForm.cs,v 1.26 2008-02-12 23:02:40 panacoran Exp $

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using System.Text.RegularExpressions;
using Protra.Controls;
using Protra.Dialogs;
using Protra.Lib;
using Protra.Lib.Config;
using Protra.Lib.Controls;
using Protra.Lib.Db;
using Protra.Lib.Dialogs;

namespace Protra
{
	/// <summary>
	/// AvP[ṼCtH[łB
	/// </summary>
	public class MainForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// őOʂ̃EBhEZbg܂B
		/// </summary>
		[DllImport("user32.dll")]
		private static extern int SetForegroundWindow(int hwnd);
		
		/// <summary>
		/// IvV
		/// </summary>
		private Option option = new Option();
		/// <summary>
		/// ʏ̃TCY
		/// </summary>
		private Rectangle normalBounds;
		/// <summary>
		/// `[gpl̍
		/// </summary>
		private int panelChartHeight;
		/// <summary>
		/// ChartBox̔z
		/// </summary>
		private ChartBox[] chartBoxes;
		/// <summary>
		/// ANeBuChartBox
		/// </summary>
		private ChartBox activeChartBox;
		/// <summary>
		/// IĂ
		/// </summary>
		private Brand selectedBrand;
		/// <summary>
		/// ̃`[g`悷vO
		/// </summary>
		private string[] dailyChartFile;
		/// <summary>
		/// T̃`[g`悷vO
		/// </summary>
		private string[] weeklyChartFile;

		private System.Windows.Forms.MainMenu mainMenu;
		private System.Windows.Forms.MenuItem menuItemData;
		private System.Windows.Forms.MenuItem menuItemPriceUpdate;
		private System.Windows.Forms.MenuItem menuItemPriceDelete;
		private System.Windows.Forms.MenuItem menuItemChart;
		private System.Windows.Forms.MenuItem menuItemAddFavoriteBrand;
		private System.Windows.Forms.MenuItem menuItemChartSep1;
		private System.Windows.Forms.MenuItem menuItemDailyChart;
		private System.Windows.Forms.MenuItem menuItemWeeklyChart;
		private System.Windows.Forms.MenuItem menuItemTool;
		private System.Windows.Forms.MenuItem menuItemPtSim;
		private System.Windows.Forms.MenuItem menuItemToolSep1;
		private System.Windows.Forms.MenuItem menuItemOption;
		private System.Windows.Forms.MenuItem menuItemHelp;
		private System.Windows.Forms.MenuItem menuItemMan;
		private System.Windows.Forms.MenuItem menuItemVersion;
		private System.Windows.Forms.Panel panelLeft;
		private System.Windows.Forms.TabControl tabControlBrand;
		private System.Windows.Forms.TabPage tabPageBrand;
		private System.Windows.Forms.TabPage tabPageFavoriteBrand;
		private Protra.Controls.BrandTreeView treeViewBrand;
		private System.Windows.Forms.ListBox listBoxFavoriteBrand;
		private System.Windows.Forms.ListView listViewPriceInfo;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.Splitter splitterPanelAndChart;
		private System.Windows.Forms.Splitter splitterBrandAndInfo;
		private System.Windows.Forms.Panel panelChart;
		private System.Windows.Forms.ToolBar toolBar;
		private System.Windows.Forms.ToolBarButton toolBarButtonPriceUpdate;
		private System.Windows.Forms.ToolBarButton toolBarButtonSep1;
		private System.Windows.Forms.ToolBarButton toolBarButtonDailyChart;
		private System.Windows.Forms.ToolBarButton toolBarButtonWeeklyChart;
		private System.Windows.Forms.ToolBarButton toolBarSep2;
		private System.Windows.Forms.ToolBarButton toolBarButtonPtSim;
		private System.Windows.Forms.ToolBarButton toolBarSep3;
		private System.Windows.Forms.ImageList imageListToolBar;
		private System.Windows.Forms.HScrollBar hScrollBarChart;
		private System.Windows.Forms.TextBox textBoxCode;
		private System.Windows.Forms.Button buttonSearch;
        private System.Windows.Forms.Label labelCode;

		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// RXgN^
		/// </summary>
		public MainForm()
		{
			//
			// Windows tH[ fUCi T|[gɕKvłB
			//
			InitializeComponent();

			dailyChartFile = new string[option.ChartNum];
			weeklyChartFile = new string[option.ChartNum];
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MainForm));
            this.splitterPanelAndChart = new System.Windows.Forms.Splitter();
            this.mainMenu = new System.Windows.Forms.MainMenu(this.components);
            this.menuItemData = new System.Windows.Forms.MenuItem();
            this.menuItemPriceUpdate = new System.Windows.Forms.MenuItem();
            this.menuItemPriceDelete = new System.Windows.Forms.MenuItem();
            this.menuItemChart = new System.Windows.Forms.MenuItem();
            this.menuItemAddFavoriteBrand = new System.Windows.Forms.MenuItem();
            this.menuItemChartSep1 = new System.Windows.Forms.MenuItem();
            this.menuItemDailyChart = new System.Windows.Forms.MenuItem();
            this.menuItemWeeklyChart = new System.Windows.Forms.MenuItem();
            this.menuItemTool = new System.Windows.Forms.MenuItem();
            this.menuItemPtSim = new System.Windows.Forms.MenuItem();
            this.menuItemToolSep1 = new System.Windows.Forms.MenuItem();
            this.menuItemOption = new System.Windows.Forms.MenuItem();
            this.menuItemHelp = new System.Windows.Forms.MenuItem();
            this.menuItemMan = new System.Windows.Forms.MenuItem();
            this.menuItemVersion = new System.Windows.Forms.MenuItem();
            this.panelLeft = new System.Windows.Forms.Panel();
            this.tabControlBrand = new System.Windows.Forms.TabControl();
            this.tabPageBrand = new System.Windows.Forms.TabPage();
            this.treeViewBrand = new Protra.Controls.BrandTreeView();
            this.tabPageFavoriteBrand = new System.Windows.Forms.TabPage();
            this.listBoxFavoriteBrand = new System.Windows.Forms.ListBox();
            this.splitterBrandAndInfo = new System.Windows.Forms.Splitter();
            this.listViewPriceInfo = new System.Windows.Forms.ListView();
            this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
            this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
            this.toolBar = new System.Windows.Forms.ToolBar();
            this.toolBarButtonPriceUpdate = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonSep1 = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonDailyChart = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonWeeklyChart = new System.Windows.Forms.ToolBarButton();
            this.toolBarSep2 = new System.Windows.Forms.ToolBarButton();
            this.toolBarButtonPtSim = new System.Windows.Forms.ToolBarButton();
            this.toolBarSep3 = new System.Windows.Forms.ToolBarButton();
            this.imageListToolBar = new System.Windows.Forms.ImageList(this.components);
            this.panelChart = new System.Windows.Forms.Panel();
            this.hScrollBarChart = new System.Windows.Forms.HScrollBar();
            this.labelCode = new System.Windows.Forms.Label();
            this.textBoxCode = new System.Windows.Forms.TextBox();
            this.buttonSearch = new System.Windows.Forms.Button();
            this.panelLeft.SuspendLayout();
            this.tabControlBrand.SuspendLayout();
            this.tabPageBrand.SuspendLayout();
            this.tabPageFavoriteBrand.SuspendLayout();
            this.SuspendLayout();
            // 
            // splitterPanelAndChart
            // 
            this.splitterPanelAndChart.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.splitterPanelAndChart.Location = new System.Drawing.Point(180, 28);
            this.splitterPanelAndChart.Name = "splitterPanelAndChart";
            this.splitterPanelAndChart.Size = new System.Drawing.Size(3, 499);
            this.splitterPanelAndChart.TabIndex = 3;
            this.splitterPanelAndChart.TabStop = false;
            // 
            // mainMenu
            // 
            this.mainMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemData,
            this.menuItemChart,
            this.menuItemTool,
            this.menuItemHelp});
            // 
            // menuItemData
            // 
            this.menuItemData.Index = 0;
            this.menuItemData.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemPriceUpdate,
            this.menuItemPriceDelete});
            this.menuItemData.Text = "f[^(&D)";
            // 
            // menuItemPriceUpdate
            // 
            this.menuItemPriceUpdate.Index = 0;
            this.menuItemPriceUpdate.Shortcut = System.Windows.Forms.Shortcut.CtrlU;
            this.menuItemPriceUpdate.Text = "f[^XV(&U)";
            this.menuItemPriceUpdate.Click += new System.EventHandler(this.menuItemPriceUpdate_Click);
            // 
            // menuItemPriceDelete
            // 
            this.menuItemPriceDelete.Index = 1;
            this.menuItemPriceDelete.Text = "f[^폜(&D)...";
            this.menuItemPriceDelete.Click += new System.EventHandler(this.menuItemPriceDelete_Click);
            // 
            // menuItemChart
            // 
            this.menuItemChart.Index = 1;
            this.menuItemChart.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemAddFavoriteBrand,
            this.menuItemChartSep1,
            this.menuItemDailyChart,
            this.menuItemWeeklyChart});
            this.menuItemChart.Text = "`[g(&C)";
            // 
            // menuItemAddFavoriteBrand
            // 
            this.menuItemAddFavoriteBrand.Index = 0;
            this.menuItemAddFavoriteBrand.Shortcut = System.Windows.Forms.Shortcut.CtrlA;
            this.menuItemAddFavoriteBrand.Text = "Cɓɒǉ(&A)";
            this.menuItemAddFavoriteBrand.Click += new System.EventHandler(this.menuItemAddFavoriteBrand_Click);
            // 
            // menuItemChartSep1
            // 
            this.menuItemChartSep1.Index = 1;
            this.menuItemChartSep1.Text = "-";
            // 
            // menuItemDailyChart
            // 
            this.menuItemDailyChart.Checked = true;
            this.menuItemDailyChart.Index = 2;
            this.menuItemDailyChart.RadioCheck = true;
            this.menuItemDailyChart.Shortcut = System.Windows.Forms.Shortcut.CtrlD;
            this.menuItemDailyChart.Text = "(&D)";
            this.menuItemDailyChart.Click += new System.EventHandler(this.menuItemDailyChart_Click);
            // 
            // menuItemWeeklyChart
            // 
            this.menuItemWeeklyChart.Index = 3;
            this.menuItemWeeklyChart.RadioCheck = true;
            this.menuItemWeeklyChart.Shortcut = System.Windows.Forms.Shortcut.CtrlW;
            this.menuItemWeeklyChart.Text = "T(&W)";
            this.menuItemWeeklyChart.Click += new System.EventHandler(this.menuItemWeeklyChart_Click);
            // 
            // menuItemTool
            // 
            this.menuItemTool.Index = 2;
            this.menuItemTool.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemPtSim,
            this.menuItemToolSep1,
            this.menuItemOption});
            this.menuItemTool.Text = "c[(&T)";
            // 
            // menuItemPtSim
            // 
            this.menuItemPtSim.Index = 0;
            this.menuItemPtSim.Text = "PtSim̋N(&S)";
            this.menuItemPtSim.Click += new System.EventHandler(this.menuItemPtSim_Click);
            // 
            // menuItemToolSep1
            // 
            this.menuItemToolSep1.Index = 1;
            this.menuItemToolSep1.Text = "-";
            // 
            // menuItemOption
            // 
            this.menuItemOption.Index = 2;
            this.menuItemOption.Text = "IvV(&O)...";
            this.menuItemOption.Click += new System.EventHandler(this.menuItemOption_Click);
            // 
            // menuItemHelp
            // 
            this.menuItemHelp.Index = 3;
            this.menuItemHelp.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.menuItemMan,
            this.menuItemVersion});
            this.menuItemHelp.Text = "wv(&H)";
            // 
            // menuItemMan
            // 
            this.menuItemMan.Index = 0;
            this.menuItemMan.Shortcut = System.Windows.Forms.Shortcut.F1;
            this.menuItemMan.Text = "}jA(&M)";
            this.menuItemMan.Click += new System.EventHandler(this.menuItemMan_Click);
            // 
            // menuItemVersion
            // 
            this.menuItemVersion.Index = 1;
            this.menuItemVersion.Text = "o[W(&V)";
            this.menuItemVersion.Click += new System.EventHandler(this.menuItemVersion_Click);
            // 
            // panelLeft
            // 
            this.panelLeft.Controls.Add(this.tabControlBrand);
            this.panelLeft.Controls.Add(this.splitterBrandAndInfo);
            this.panelLeft.Controls.Add(this.listViewPriceInfo);
            this.panelLeft.Dock = System.Windows.Forms.DockStyle.Left;
            this.panelLeft.Location = new System.Drawing.Point(0, 28);
            this.panelLeft.Name = "panelLeft";
            this.panelLeft.Size = new System.Drawing.Size(180, 499);
            this.panelLeft.TabIndex = 1;
            // 
            // tabControlBrand
            // 
            this.tabControlBrand.Controls.Add(this.tabPageBrand);
            this.tabControlBrand.Controls.Add(this.tabPageFavoriteBrand);
            this.tabControlBrand.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tabControlBrand.Location = new System.Drawing.Point(0, 0);
            this.tabControlBrand.Name = "tabControlBrand";
            this.tabControlBrand.SelectedIndex = 0;
            this.tabControlBrand.Size = new System.Drawing.Size(180, 360);
            this.tabControlBrand.TabIndex = 0;
            // 
            // tabPageBrand
            // 
            this.tabPageBrand.Controls.Add(this.treeViewBrand);
            this.tabPageBrand.Location = new System.Drawing.Point(4, 21);
            this.tabPageBrand.Name = "tabPageBrand";
            this.tabPageBrand.Size = new System.Drawing.Size(172, 335);
            this.tabPageBrand.TabIndex = 0;
            this.tabPageBrand.Text = "Xg";
            // 
            // treeViewBrand
            // 
            this.treeViewBrand.Dock = System.Windows.Forms.DockStyle.Fill;
            this.treeViewBrand.HideSelection = false;
            this.treeViewBrand.Location = new System.Drawing.Point(0, 0);
            this.treeViewBrand.Name = "treeViewBrand";
            this.treeViewBrand.Size = new System.Drawing.Size(172, 335);
            this.treeViewBrand.TabIndex = 0;
            this.treeViewBrand.AfterSelect += new System.Windows.Forms.TreeViewEventHandler(this.treeViewBrand_AfterSelect);
            // 
            // tabPageFavoriteBrand
            // 
            this.tabPageFavoriteBrand.Controls.Add(this.listBoxFavoriteBrand);
            this.tabPageFavoriteBrand.Location = new System.Drawing.Point(4, 21);
            this.tabPageFavoriteBrand.Name = "tabPageFavoriteBrand";
            this.tabPageFavoriteBrand.Size = new System.Drawing.Size(172, 335);
            this.tabPageFavoriteBrand.TabIndex = 1;
            this.tabPageFavoriteBrand.Text = "Cɓ";
            // 
            // listBoxFavoriteBrand
            // 
            this.listBoxFavoriteBrand.Dock = System.Windows.Forms.DockStyle.Fill;
            this.listBoxFavoriteBrand.ItemHeight = 12;
            this.listBoxFavoriteBrand.Location = new System.Drawing.Point(0, 0);
            this.listBoxFavoriteBrand.Name = "listBoxFavoriteBrand";
            this.listBoxFavoriteBrand.Size = new System.Drawing.Size(172, 328);
            this.listBoxFavoriteBrand.Sorted = true;
            this.listBoxFavoriteBrand.TabIndex = 0;
            this.listBoxFavoriteBrand.SelectedIndexChanged += new System.EventHandler(this.listBoxFavoriteBrand_SelectedIndexChanged);
            this.listBoxFavoriteBrand.KeyDown += new System.Windows.Forms.KeyEventHandler(this.listBoxFavoriteBrand_KeyDown);
            // 
            // splitterBrandAndInfo
            // 
            this.splitterBrandAndInfo.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.splitterBrandAndInfo.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.splitterBrandAndInfo.Location = new System.Drawing.Point(0, 360);
            this.splitterBrandAndInfo.Name = "splitterBrandAndInfo";
            this.splitterBrandAndInfo.Size = new System.Drawing.Size(180, 3);
            this.splitterBrandAndInfo.TabIndex = 1;
            this.splitterBrandAndInfo.TabStop = false;
            // 
            // listViewPriceInfo
            // 
            this.listViewPriceInfo.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2});
            this.listViewPriceInfo.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.listViewPriceInfo.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.None;
            this.listViewPriceInfo.Location = new System.Drawing.Point(0, 363);
            this.listViewPriceInfo.Name = "listViewPriceInfo";
            this.listViewPriceInfo.Size = new System.Drawing.Size(180, 136);
            this.listViewPriceInfo.TabIndex = 1;
            this.listViewPriceInfo.UseCompatibleStateImageBehavior = false;
            this.listViewPriceInfo.View = System.Windows.Forms.View.Details;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Width = 100;
            // 
            // toolBar
            // 
            this.toolBar.Appearance = System.Windows.Forms.ToolBarAppearance.Flat;
            this.toolBar.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
            this.toolBarButtonPriceUpdate,
            this.toolBarButtonSep1,
            this.toolBarButtonDailyChart,
            this.toolBarButtonWeeklyChart,
            this.toolBarSep2,
            this.toolBarButtonPtSim,
            this.toolBarSep3});
            this.toolBar.DropDownArrows = true;
            this.toolBar.ImageList = this.imageListToolBar;
            this.toolBar.Location = new System.Drawing.Point(0, 0);
            this.toolBar.Name = "toolBar";
            this.toolBar.ShowToolTips = true;
            this.toolBar.Size = new System.Drawing.Size(790, 28);
            this.toolBar.TabIndex = 0;
            this.toolBar.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar_ButtonClick);
            // 
            // toolBarButtonPriceUpdate
            // 
            this.toolBarButtonPriceUpdate.ImageIndex = 0;
            this.toolBarButtonPriceUpdate.Name = "toolBarButtonPriceUpdate";
            this.toolBarButtonPriceUpdate.ToolTipText = "f[^XV";
            // 
            // toolBarButtonSep1
            // 
            this.toolBarButtonSep1.Name = "toolBarButtonSep1";
            this.toolBarButtonSep1.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
            // 
            // toolBarButtonDailyChart
            // 
            this.toolBarButtonDailyChart.ImageIndex = 1;
            this.toolBarButtonDailyChart.Name = "toolBarButtonDailyChart";
            this.toolBarButtonDailyChart.Pushed = true;
            this.toolBarButtonDailyChart.ToolTipText = "";
            // 
            // toolBarButtonWeeklyChart
            // 
            this.toolBarButtonWeeklyChart.ImageIndex = 2;
            this.toolBarButtonWeeklyChart.Name = "toolBarButtonWeeklyChart";
            this.toolBarButtonWeeklyChart.ToolTipText = "T";
            // 
            // toolBarSep2
            // 
            this.toolBarSep2.Name = "toolBarSep2";
            this.toolBarSep2.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
            // 
            // toolBarButtonPtSim
            // 
            this.toolBarButtonPtSim.ImageIndex = 3;
            this.toolBarButtonPtSim.Name = "toolBarButtonPtSim";
            this.toolBarButtonPtSim.ToolTipText = "PtSim̋N";
            // 
            // toolBarSep3
            // 
            this.toolBarSep3.Name = "toolBarSep3";
            this.toolBarSep3.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
            // 
            // imageListToolBar
            // 
            this.imageListToolBar.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListToolBar.ImageStream")));
            this.imageListToolBar.TransparentColor = System.Drawing.Color.Transparent;
            this.imageListToolBar.Images.SetKeyName(0, "");
            this.imageListToolBar.Images.SetKeyName(1, "");
            this.imageListToolBar.Images.SetKeyName(2, "");
            this.imageListToolBar.Images.SetKeyName(3, "");
            // 
            // panelChart
            // 
            this.panelChart.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelChart.Location = new System.Drawing.Point(183, 28);
            this.panelChart.Name = "panelChart";
            this.panelChart.Size = new System.Drawing.Size(607, 484);
            this.panelChart.TabIndex = 7;
            // 
            // hScrollBarChart
            // 
            this.hScrollBarChart.Dock = System.Windows.Forms.DockStyle.Bottom;
            this.hScrollBarChart.Enabled = false;
            this.hScrollBarChart.Location = new System.Drawing.Point(183, 512);
            this.hScrollBarChart.Name = "hScrollBarChart";
            this.hScrollBarChart.Size = new System.Drawing.Size(607, 15);
            this.hScrollBarChart.TabIndex = 8;
            this.hScrollBarChart.Scroll += new System.Windows.Forms.ScrollEventHandler(this.hScrollBarChart_Scroll);
            // 
            // labelCode
            // 
            this.labelCode.Location = new System.Drawing.Point(116, 8);
            this.labelCode.Name = "labelCode";
            this.labelCode.Size = new System.Drawing.Size(76, 16);
            this.labelCode.TabIndex = 3;
            this.labelCode.Text = "R[h/";
            // 
            // textBoxCode
            // 
            this.textBoxCode.Location = new System.Drawing.Point(192, 4);
            this.textBoxCode.Name = "textBoxCode";
            this.textBoxCode.Size = new System.Drawing.Size(72, 19);
            this.textBoxCode.TabIndex = 4;
            this.textBoxCode.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.textBoxCode_KeyPress);
            // 
            // buttonSearch
            // 
            this.buttonSearch.FlatStyle = System.Windows.Forms.FlatStyle.Popup;
            this.buttonSearch.Image = ((System.Drawing.Image)(resources.GetObject("buttonSearch.Image")));
            this.buttonSearch.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
            this.buttonSearch.Location = new System.Drawing.Point(268, 4);
            this.buttonSearch.Name = "buttonSearch";
            this.buttonSearch.Size = new System.Drawing.Size(56, 20);
            this.buttonSearch.TabIndex = 5;
            this.buttonSearch.Text = "";
            this.buttonSearch.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.buttonSearch.Click += new System.EventHandler(this.buttonSearch_Click);
            // 
            // MainForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.ClientSize = new System.Drawing.Size(790, 527);
            this.Controls.Add(this.buttonSearch);
            this.Controls.Add(this.textBoxCode);
            this.Controls.Add(this.labelCode);
            this.Controls.Add(this.panelChart);
            this.Controls.Add(this.hScrollBarChart);
            this.Controls.Add(this.splitterPanelAndChart);
            this.Controls.Add(this.panelLeft);
            this.Controls.Add(this.toolBar);
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.Menu = this.mainMenu;
            this.Name = "MainForm";
            this.Text = "Protra";
            this.Load += new System.EventHandler(this.MainForm_Load);
            this.SizeChanged += new System.EventHandler(this.MainForm_SizeChanged);
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.MainForm_FormClosing);
            this.LocationChanged += new System.EventHandler(this.MainForm_LocationChanged);
            this.panelLeft.ResumeLayout(false);
            this.tabControlBrand.ResumeLayout(false);
            this.tabPageBrand.ResumeLayout(false);
            this.tabPageFavoriteBrand.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// ݒt@Cǂݍ݂܂B
		/// </summary>
		private void EnvRead()
		{
			ConfigFile configFile = new ConfigFile("ptenv");
			try
			{
				configFile.Read();
			}
			catch
			{
				return;
			}
			try
			{
				// tH[
				this.Width = int.Parse(configFile["Width"]);
				this.Height = int.Parse(configFile["Height"]);
				if(bool.Parse(configFile["Maximized"]))
					this.WindowState = FormWindowState.Maximized;
				this.panelLeft.Width = int.Parse(configFile["PanelLeftWidth"]);
				this.listViewPriceInfo.Height =
					int.Parse(configFile["TextBoxPriceInfoHeight"]);
				// `[g
				for (int i = 0; i < option.ChartNum; i++)
				{
					chartBoxes[i].Height =
						int.Parse(configFile["ChartHeight" + i.ToString()]);
					chartBoxes[i].ProgramFile =
						Path.Combine(Global.DirChart, configFile["ChartFile" + i.ToString()]);
					string weeklyFile = configFile["WeeklyChartFile" + i.ToString()];
					if (weeklyFile != null)
						weeklyChartFile[i] = Path.Combine(Global.DirChart, weeklyFile);
				}
				if (int.Parse(configFile["ChartMode"]) == 1)
					this.menuItemWeeklyChart.PerformClick();
				// Cɓ
				for(int i = 0; ; i++)
				{
					string val = configFile["FavoriteBrandId" + i.ToString()];
					if(val == null)
						break;
					Brand brand = BrandTable.GetRecord(int.Parse(val));
					if (brand != null)
						this.listBoxFavoriteBrand.Items.Add(new FavoriteBrandItem(brand));
				}
			}
			catch (ArgumentNullException) {}
			catch (FormatException) {}
		}

		private string StripChartDirName(string path)
		{
			if (path == null)
				return null;
			return path.Substring(Global.DirChart.Length + 1, path.Length - Global.DirChart.Length - 1);
		}

		/// <summary>
		/// ݒt@C݂܂B
		/// </summary>
		private void EnvWrite()
		{
			ConfigFile configFile = new ConfigFile("ptenv");
			// tH[
			configFile["Width"] = normalBounds.Width.ToString();
			configFile["Height"] = normalBounds.Height.ToString();
			configFile["Maximized"] =
				(this.WindowState == FormWindowState.Maximized).ToString();
			configFile["PanelLeftWidth"] = this.panelLeft.Width.ToString();
			configFile["TextBoxPriceInfoHeight"] = this.listViewPriceInfo.Height.ToString();
			// `[g
			int mode = this.menuItemDailyChart.Checked ? 0 : 1;
			configFile["ChartMode"] = mode.ToString();
			for(int i = 0; i < option.ChartNum; i++)
			{
				// ݒ肳Ă`[gt@C擾B
				if (menuItemDailyChart.Checked == true || !option.UseDifferentChart)
					dailyChartFile[i] = chartBoxes[i].ProgramFile;
				else
					weeklyChartFile[i] = chartBoxes[i].ProgramFile;
				configFile["ChartFile" + i.ToString()] = StripChartDirName(dailyChartFile[i]);
				configFile["WeeklyChartFile" + i.ToString()] = StripChartDirName(weeklyChartFile[i]);
				configFile["ChartHeight" + i.ToString()] = chartBoxes[i].Height.ToString();
			}
			// Cɓ
			int num = 0;
			foreach (FavoriteBrandItem item in this.listBoxFavoriteBrand.Items)
				configFile["FavoriteBrandId" + num++.ToString()] = item.Brand.Id.ToString();
			configFile.Write();
		}

		/// <summary>
		/// `[g܂B
		/// </summary>
		private void InitChartBoxes()
		{
			chartBoxes = new ChartBox[option.ChartNum];
			ChartBox chartBox;
			int height = this.panelChart.Height / option.ChartNum;
			int i;
			for(i = 0; i < option.ChartNum - 1; i++)
			{
				chartBox = new ChartBox();
				chartBox.Height = height;
				chartBox.Dock = DockStyle.Top;
				chartBox.BackColor = option.ChartBackColor;
				chartBox.ForeColor = option.ChartForeColor;
				chartBox.MouseDown += new MouseEventHandler(this.chartBox_MouseDown);
				this.panelChart.Controls.Add(chartBox);
				this.panelChart.Controls.SetChildIndex(chartBox, 0);
				chartBoxes[i] = chartBox;

				Splitter splitter = new Splitter();
				splitter.Dock = DockStyle.Top;
				splitter.BorderStyle = BorderStyle.Fixed3D;
				this.panelChart.Controls.Add(splitter);
				this.panelChart.Controls.SetChildIndex(splitter, 0);
			}
			chartBox = new ChartBox();
			chartBox.Dock = DockStyle.Fill;
			chartBox.BackColor = option.ChartBackColor;
			chartBox.ForeColor = option.ChartForeColor;
			chartBox.MouseDown += new MouseEventHandler(this.chartBox_MouseDown);
			this.panelChart.Controls.Add(chartBox);
			this.panelChart.Controls.SetChildIndex(chartBox, 0);
			chartBoxes[i] = chartBox;
		}

		/// <summary>
		/// IꂽZbg܂B
		/// </summary>
		/// <param name="brand">Brand</param>
		private void SetSelectedBrand(Brand brand)
		{
			selectedBrand = brand;
			Price[] prices = null;
			if(selectedBrand != null)
			{
				if(this.menuItemDailyChart.Checked)
					prices = PriceTable.PriceList(selectedBrand.Id);
				else
					prices = PriceTable.WeeklyPriceList(selectedBrand.Id, option.DrawLastWeek);
			}
			SetListViewPriceInfo(prices);
			SetChartBoxPrices(prices);
		}

		/// <summary>
		/// `[gɊf[^Zbg܂B
		/// </summary>
		/// <param name="prices">f[^</param>
		private void SetChartBoxPrices(Price[] prices)
		{
			foreach(ChartBox chartBox in chartBoxes)
				chartBox.Prices = prices;
			if(prices == null)
				this.hScrollBarChart.Enabled = false;
			else
			{
				int count = chartBoxes[0].Count;
				if(prices.Length < count)
					this.hScrollBarChart.Enabled = false;
				else
				{
					this.hScrollBarChart.Maximum = prices.Length - 1;
					this.hScrollBarChart.Value = prices.Length - count;
					this.hScrollBarChart.LargeChange = count;
					this.hScrollBarChart.Enabled = true;
				}
			}
		}

		/// <summary>
		/// Zbg܂B
		/// </summary>
		/// <param name="prices">f[^</param>
		private void SetListViewPriceInfo(Price[] prices)
		{
			if(prices == null || prices.Length == 0)
			{
				this.listViewPriceInfo.Items.Clear();
				return;
			}

			Price p = prices[prices.Length - 1];
			ListViewItem[] items = new ListViewItem[9];
			items[0] = new ListViewItem(new string[]{"R[h", p.Brand.Code.ToString()});
			items[1] = new ListViewItem(new string[]{"s", p.Brand.Market.Name});
			items[2] = new ListViewItem(new string[]{"", p.Brand.Name});
			items[3] = new ListViewItem(new string[]{"t", p.Date.ToString("yyyy/MM/dd")});
			items[4] = new ListViewItem(new string[]{"nl", p.Open.ToString()});
			items[5] = new ListViewItem(new string[]{"l", p.High.ToString()});
			items[6] = new ListViewItem(new string[]{"l", p.Low.ToString()});
			items[7] = new ListViewItem(new string[]{"Il", p.Close.ToString()});
			items[8] = new ListViewItem(new string[]{"o", p.Volume.ToString()});
			this.listViewPriceInfo.Items.Clear();
			this.listViewPriceInfo.Items.AddRange(items);
		}

		/// <summary>
		/// ChartBoxp̃ReLXgj[𐶐܂B
		/// </summary>
		/// <returns>ChartBoxp̃ReLXgj[łB</returns>
		private ContextMenu CreateContextMenuChartBox()
		{
			ContextMenu contextMenu = new ContextMenu();
			string dir = Global.DirChart;
			if(Directory.Exists(dir))
			{
				string[] dirlist = Directory.GetDirectories(dir);
				foreach(string s in dirlist)
				{
					MenuItem newMenuItem = CreateContextMenuItemChartBox(s);
					contextMenu.MenuItems.Add(newMenuItem);
				}
				string[] filelist = Directory.GetFiles(dir, "*.pt");
				foreach(string s in filelist)
				{
					MenuItemWithObject newMenuItem = new MenuItemWithObject();
					newMenuItem.Text = Path.GetFileNameWithoutExtension(s).Replace("&", "&&");
					newMenuItem.Object = s;
					newMenuItem.Click += new EventHandler(this.menuItemChartFile_Click);
					contextMenu.MenuItems.Add(newMenuItem);
				}
			}
			return contextMenu;
		}

		/// <summary>
		/// ChartBoxp̃ReLXgj[MenuItem𐶐܂B
		/// </summary>
		/// <returns>ChartBoxp̃ReLXgj[MenuItemłB</returns>
		private MenuItem CreateContextMenuItemChartBox(string dir)
		{
			MenuItem menuItem = new MenuItem();
			menuItem.Text = Path.GetFileName(dir).Replace("&", "&&");
			if(Directory.Exists(dir))
			{
				string[] dirlist = Directory.GetDirectories(dir);
				foreach(string s in dirlist)
				{
					MenuItem newMenuItem = CreateContextMenuItemChartBox(s);
					menuItem.MenuItems.Add(newMenuItem);
				}
				string[] filelist = Directory.GetFiles(dir, "*.pt");
				foreach(string s in filelist)
				{
					MenuItemWithObject newMenuItem = new MenuItemWithObject();
					newMenuItem.Text = Path.GetFileNameWithoutExtension(s).Replace("&", "&&");
					newMenuItem.Object = s;
					newMenuItem.Click += new EventHandler(this.menuItemChartFile_Click);
					menuItem.MenuItems.Add(newMenuItem);
				}
			}
			return menuItem;
		}

		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Process cps = Process.GetCurrentProcess();
			Process[] ps = Process.GetProcessesByName(cps.ProcessName);
			if(ps.Length > 1)
			{
				int i = 0;
				if(ps[0].Id == cps.Id)
					i = 1;
				SetForegroundWindow(ps[i].MainWindowHandle.ToInt32());
				return;
			}
			
			Application.Run(new MainForm());
		}

		private void MainForm_Load(object sender, System.EventArgs e)
		{
			InitChartBoxes();
			this.treeViewBrand.Initialize();

			// TCY̕ۑ
			normalBounds = this.Bounds;

			// ݒt@C̓ǂݍ
			EnvRead();

			// `[gpl̏
			panelChartHeight = this.panelChart.Height;
			this.panelChart.SizeChanged += new System.EventHandler(this.panelChart_SizeChanged);
		}

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            EnvWrite();
        }
	
		private void MainForm_LocationChanged(object sender, System.EventArgs e)
		{
			// ʏ̏ԂȂTCYۑ
			if(this.WindowState == FormWindowState.Normal)
				normalBounds = this.Bounds;
		}

		private void MainForm_SizeChanged(object sender, System.EventArgs e)
		{
			// ʏ̏ԂȂTCYۑ
			if(this.WindowState == FormWindowState.Normal)
				normalBounds = this.Bounds;
		}

		private void chartBox_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			activeChartBox = (ChartBox)sender;
			if(e.Button == MouseButtons.Right)
			{
				ContextMenu contextMenu = this.CreateContextMenuChartBox();
				contextMenu.Show((Control)sender, new Point(e.X, e.Y));
			}
		}

		private void menuItemChartFile_Click(object sender, System.EventArgs e)
		{
			MenuItemWithObject menuItem = (MenuItemWithObject)sender;
			string file = (string)menuItem.Object;
			activeChartBox.ProgramFile = file;
		}

		private void menuItemSearchedBrand_Click(object sender, System.EventArgs e)
		{
			MenuItemWithObject menuItem = (MenuItemWithObject)sender;
			Brand brand = (Brand)menuItem.Object;
			listBoxFavoriteBrand.SelectedItem = null;
			treeViewBrand.SelectedNode = null;
			SetSelectedBrand(brand);
		}
		
		private void menuItemPriceUpdate_Click(object sender, System.EventArgs e)
		{
			PriceUpdateDialog updateDialog = new PriceUpdateDialog(option);
			updateDialog.ShowDialog();

			if(selectedBrand != null)
				SetSelectedBrand(selectedBrand);
			else
				this.treeViewBrand.Initialize();
		}

		private void menuItemPriceDelete_Click(object sender, System.EventArgs e)
		{
			InputDateDialog dialog = new InputDateDialog();
			dialog.Message = "w肵tȍ~̃f[^폜܂B";
			dialog.Value = PriceTable.MaxDate();
			dialog.ShowDialog();
			if(dialog.DialogResult != DialogResult.OK)
				return;
            this.Cursor = Cursors.WaitCursor;
            Application.DoEvents();
            PriceTable.Delete(dialog.Value);
            this.Cursor = Cursors.Default;
            SetSelectedBrand(selectedBrand);
        }

		private void menuItemDailyChart_Click(object sender, System.EventArgs e)
		{
			if (this.menuItemWeeklyChart.Checked && option.UseDifferentChart)
				for (int i = 0; i < option.ChartNum; i++)
					weeklyChartFile[i] = chartBoxes[i].ProgramFile;
			this.menuItemDailyChart.Checked = true;
			this.menuItemWeeklyChart.Checked = false;
			this.toolBarButtonDailyChart.Pushed = true;
			this.toolBarButtonWeeklyChart.Pushed = false;
			SetSelectedBrand(selectedBrand);
			for (int i = 0; i < option.ChartNum; i++)
			{
				if (option.UseDifferentChart)
					chartBoxes[i].ProgramFile = dailyChartFile[i];
				chartBoxes[i].MonthInterval = 1;
			}
		}

		private void menuItemWeeklyChart_Click(object sender, System.EventArgs e)
		{
			if (this.menuItemDailyChart.Checked && option.UseDifferentChart)
				for (int i = 0; i < option.ChartNum; i++)
					dailyChartFile[i] = chartBoxes[i].ProgramFile;
			this.menuItemDailyChart.Checked = false;
			this.menuItemWeeklyChart.Checked = true;
			this.toolBarButtonDailyChart.Pushed = false;
			this.toolBarButtonWeeklyChart.Pushed = true;
			SetSelectedBrand(selectedBrand);
			for (int i = 0; i < option.ChartNum; i++)
			{
				if (option.UseDifferentChart)
					chartBoxes[i].ProgramFile = weeklyChartFile[i];
				chartBoxes[i].MonthInterval = 4;
			}
		}

		private void menuItemAddFavoriteBrand_Click(object sender, System.EventArgs e)
		{
			object item = new FavoriteBrandItem(selectedBrand);
			if(! this.listBoxFavoriteBrand.Items.Contains(item))
				this.listBoxFavoriteBrand.Items.Add(item);
		}

		private void menuItemPtSim_Click(object sender, System.EventArgs e)
		{
			string path = Path.Combine(Global.DirApp, "PtSim.exe");
			Process.Start(path);
		}

		private void menuItemOption_Click(object sender, System.EventArgs e)
		{
			int chartNum = option.ChartNum;
			bool drawLastWeek = option.DrawLastWeek;
			Form dialog = new OptionDialog(option);
			DialogResult result = dialog.ShowDialog(this);
			if(result == DialogResult.OK)
			{
				foreach(ChartBox chartBox in chartBoxes)
				{
					chartBox.BackColor = option.ChartBackColor;
					chartBox.ForeColor = option.ChartForeColor;
				}

				if(chartNum != option.ChartNum)
				{
					ChartBox[] preChartBoxes = chartBoxes;
					for(int i = 0; i < chartNum*2 - 1; i++)
						this.panelChart.Controls.RemoveAt(0);
					InitChartBoxes();
					
					for(int i = 0; i < option.ChartNum; i++)
					{
						chartBoxes[i].Prices = preChartBoxes[0].Prices;
						chartBoxes[i].MonthInterval =
							this.menuItemDailyChart.Checked ? 1 : 4;
					}
					int m = Math.Min(chartNum, option.ChartNum);
					string[] preDailyChartFile = dailyChartFile;
					string[] preWeeklyChartFile = weeklyChartFile;
					dailyChartFile = new string[option.ChartNum];
					weeklyChartFile = new string[option.ChartNum];
					for(int i = 0; i < m; i++)
					{
						chartBoxes[i].ProgramFile = preChartBoxes[i].ProgramFile;
						dailyChartFile[i] = preDailyChartFile[i];
						weeklyChartFile[i] = preWeeklyChartFile[i];
					}
				}
				if (drawLastWeek != option.DrawLastWeek && menuItemWeeklyChart.Checked)
					SetSelectedBrand(selectedBrand);
			}
		}

		private void menuItemMan_Click(object sender, System.EventArgs e)
		{
			Process.Start(Global.PathMan);
		}

		private void menuItemVersion_Click(object sender, System.EventArgs e)
		{
			Form dialog = new VersionDialog();
			dialog.ShowDialog(this);
		}

		private void toolBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			if(e.Button == this.toolBarButtonPriceUpdate)
				this.menuItemPriceUpdate.PerformClick();
			else if(e.Button == this.toolBarButtonDailyChart)
				this.menuItemDailyChart.PerformClick();
			else if(e.Button == this.toolBarButtonWeeklyChart)
				this.menuItemWeeklyChart.PerformClick();
			else if(e.Button == this.toolBarButtonPtSim)
				this.menuItemPtSim.PerformClick();
		}

		private void treeViewBrand_AfterSelect(object sender, System.Windows.Forms.TreeViewEventArgs e)
		{
			Brand brand = this.treeViewBrand.SelectedBrand;
			if(brand != null)
			{
				listBoxFavoriteBrand.SelectedItem = null;
				SetSelectedBrand(brand);
			}
		}

		private void listBoxFavoriteBrand_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			int index = this.listBoxFavoriteBrand.SelectedIndex;
			if(e.KeyData == Keys.Delete && index != -1)
			{
				this.listBoxFavoriteBrand.Items.RemoveAt(index);
				if(index < this.listBoxFavoriteBrand.Items.Count)
					this.listBoxFavoriteBrand.SelectedIndex = index;
				else if(this.listBoxFavoriteBrand.Items.Count > 0)
					this.listBoxFavoriteBrand.SelectedIndex = index - 1;
			}
		}

		private void listBoxFavoriteBrand_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			treeViewBrand.SelectedNode = null;
			object item = this.listBoxFavoriteBrand.SelectedItem;
			if(item == null)
			{
				SetSelectedBrand(null);
				return;
			}
			Brand brand = ((FavoriteBrandItem)item).Brand;
			SetSelectedBrand(brand);
		}

		private void panelChart_SizeChanged(object sender, System.EventArgs e)
		{
			if(this.panelChart.Height > 0 && panelChartHeight > 0)
			{
				double r = (double)this.panelChart.Height/panelChartHeight;
				foreach(ChartBox chartBox in chartBoxes)
					chartBox.Height = (int)(chartBox.Height * r);
			}
			panelChartHeight = this.panelChart.Height;
			
			int count = chartBoxes[0].Count;
			if(count > 0)
			{
				Price[] prices = chartBoxes[0].Prices;
				if(prices == null || prices.Length < count)
					this.hScrollBarChart.Enabled = false;
				else
				{
					this.hScrollBarChart.LargeChange = count;
					this.hScrollBarChart.Enabled = true;
				}
			}
		}

		private void hScrollBarChart_Scroll(object sender, System.Windows.Forms.ScrollEventArgs e)
		{
			if(e.Type == ScrollEventType.EndScroll)
			{
				int index = e.NewValue + this.hScrollBarChart.LargeChange - 1;
				if(index != chartBoxes[0].RightIndex)
					foreach(ChartBox chartBox in chartBoxes)
						chartBox.RightIndex = index;
			}
		}

		private void buttonSearch_Click(object sender, System.EventArgs e)
		{
			if(textBoxCode.Text == "")
				return;
			Brand[] brands;
			try
			{
				brands = BrandTable.GetRecords(int.Parse(textBoxCode.Text));
			}
			catch(FormatException)
			{
				
				brands = BrandTable.GetRecords(textBoxCode.Text);
			}
			ContextMenu contextMenu = new ContextMenu();
			foreach(Brand brand in brands)
			{
				MenuItemWithObject menuItem = new MenuItemWithObject();
				menuItem.Text = brand.Market.Name + " " + brand.Code + " " + brand.Name;
				menuItem.Object = brand;
				menuItem.Click += new EventHandler(menuItemSearchedBrand_Click);
				contextMenu.MenuItems.Add(menuItem);
			}
			contextMenu.Show(this.buttonSearch, new Point(0, this.buttonSearch.Height));
		}

		private void textBoxCode_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			if (e.KeyChar == (char)13)
			{
				buttonSearch_Click(sender, new EventArgs());
				e.Handled = true;
			}
		}
    }
}
