// Copyright(C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: PrefixedExpressionNode.cs,v 1.5 2008-04-18 14:15:50 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// Oũm[h\NXB
	/// </summary>
	public class PrefixedExpressionNode : Node
	{
		/// <summary>
		/// Z̎ނ\LN^
		/// </summary>
		char op;
		/// <summary>
		/// @pf̒lɑΉm[h
		/// </summary>
		Node atNode;
		/// <summary>
		/// LXg̃^Cv
		/// </summary>
		Value.Type type;
		/// <summary>
		/// ̃m[h
		/// </summary>
		Node expNode;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
            Token = Scanner.Token;
            if (Token.Type != TokenType.Operator)
                return new SuffixedExpressionNode().Parse();
            string token = Token.Value;
			switch (token)
			{
				case "{": // @pf
                    op = token[0];
                    Scanner.Scan();
					atNode = new ExpressionNode().Parse();
					if (Scanner.Token.Value != "}")
						throw new ParseException("'}' expected", Token);
                    Scanner.Scan();
					break;
				case "+":
				case "-":
				case "!":
					op = token[0];
					Scanner.Scan();
					break;
				case "(": // LXg̉\
                    Token peek = Scanner.Peek(); // ǂ
                    if (peek.Type != TokenType.Type)
                        return new SuffixedExpressionNode().Parse();
                    op = token[0];
                    Scanner.Scan();
                    type = (Value.Type)Enum.Parse
                        (typeof(Value.Type), Scanner.Token.Value, true);
                    Scanner.Scan();
                    if (Scanner.Token.Value != ")")
                        throw new ParseException("')' expected", Scanner.Token);
                    Scanner.Scan();
					break;
				default:
					return new SuffixedExpressionNode().Parse();
			}
            expNode = new PrefixedExpressionNode().Parse();
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
            try
            {
                switch (op)
                {
                    case '{': // @pf
                        Value val = atNode.Execute(resource, at);
                        if (val.ValueType != Value.Type.Int)
                            throw new RuntimeException("non-int value for at operator", Token);
                        return expNode.Execute(resource, at + (int)val.InnerValue);
                    case '+':
                        return +expNode.Execute(resource, at);
                    case '-':
                        return -expNode.Execute(resource, at);
                    case '!':
                        return !expNode.Execute(resource, at);
                    case '(': // LXg
                        val = expNode.Execute(resource, at);
                        if (val == null)
                            throw new RuntimeException("null casted", Token);
                        return val.Cast(type);
                }
            }
            catch (RuntimeException e)
            {
                e.Token = Token;
                throw e;
            }
			return expNode.Execute(resource, at);
		}
	}
}
