﻿// Copyright (C) 2012 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MainForm.cs 405 2010-12-09 06:26:20Z panacoran $

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Protra.Lib;
using Protra.Lib.Config;
using Protra.Lib.Data;

namespace PtSim.Dialogs
{
    public partial class SelectSystemAndTargetDialog : Form
    {
        public SelectSystemAndTargetDialog()
        {
            InitializeComponent();

            BrandListInit();
            // 前回選択されていた銘柄リストを選択する。
            foreach (var bl in GlobalEnv.BrandListConfig.List)
                if (GlobalEnv.PtSimConfig.BrandListName == bl.Name)
                {
                    comboBoxBrandList.SelectedItem = bl;
                    break;
                }
            if (GlobalEnv.PtSimConfig.Mode == 1)
                radioButtonWeekly.PerformClick();

            ptFileTreeView.Root = Global.DirSystem; // システム一覧を更新する。
        }

        /// <summary>
        /// 選択されたSystemAndTargetオブジェクトを取得する。
        /// </summary>
        public SystemAndTarget SystemAndTarget
        {
            get
            {
                var sat = new SystemAndTarget();

                if (this.ptFileTreeView.SelectedRelativeFile == null)
                    return null;
                sat.SystemFileName = this.ptFileTreeView.SelectedRelativeFile;
                if (this.comboBoxBrandList.SelectedItem == null)
                    return null;
                sat.BrandListName = ((BrandList)this.comboBoxBrandList.SelectedItem).Name;
                sat.Mode = radioButtonDaily.Checked ? 0 : 1;
                return sat;
            }
        }

        private void BrandListInit()
        {
            var item = (Protra.Lib.Config.BrandList)comboBoxBrandList.SelectedItem;
            SuspendLayout();
            comboBoxBrandList.Items.Clear();
            foreach (var bl in GlobalEnv.BrandListConfig.List)
            {
                comboBoxBrandList.Items.Add(bl);
                if (item != null && item.Name == bl.Name)
                    comboBoxBrandList.SelectedItem = bl;
            }
            if (comboBoxBrandList.SelectedItem == null &&
                comboBoxBrandList.Items.Count > 0)
                comboBoxBrandList.SelectedIndex = 0;
            ResumeLayout();
        }

        /// <summary>
        /// 設定ファイルを書き込む。
        /// </summary>
        private void ConfigWrite()
        {
            var p = GlobalEnv.PtSimConfig;
            p.Mode = radioButtonDaily.Checked ? 0 : 1;
            var item = (BrandList)comboBoxBrandList.SelectedItem;
            p.BrandListName = item != null ? item.Name : null;
            p.Save();
        }

        private void SelectSystemAndTargetDialog_KeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.F5 || (e.KeyCode == Keys.R && e.Control))
                ptFileTreeView.Root = Global.DirSystem;
        }

        private void SelectSystemAndTargetDialog_FormClosing(object sender, FormClosingEventArgs e)
        {
            ConfigWrite();
        }
    }
}
