﻿// Copyright (C) 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: MathBuiltins.cs 444 2013-03-11 04:41:16Z panacoran $

using System;

namespace Protra.Lib.Lang.Builtins
{
    /// <summary>
    /// 数学関係の組み込み関数を実行するクラス。
    /// </summary>
    public class MathBuiltins : CoreBuiltins
    {
        static readonly Random random = new Random();

        private delegate double MathFunction(double d);

        /// <summary>
        /// 組み込み関数を実行する。
        /// </summary>
        /// <param name="name">名前</param>
        /// <param name="args">引数</param>
        /// <param name="at">int型@作用素</param>
        /// <param name="ats">string型@作用素</param>
        /// <returns></returns>
        public override Value Invoke(string name, Value[] args, int at, string ats)
        {
            if (name == "Random")
            {
                if (args.Length == 0)
                    return new Value(random.NextDouble());
                if (args.Length == 1)
                    return new Value(random.Next((int)(args[0].Cast(Value.Type.Int).InnerValue)));
            }
            else if (args.Length == 1)
            {
                MathFunction function;
                switch (name)
                {
                    case "Exp":
                        function = Math.Exp;
                        break;
                    case "Log":
                        function = Math.Log;
                        break;
                    case "Sqrt":
                        function = Math.Sqrt;
                        break;
                    case "Sin":
                        function = Math.Sin;
                        break;
                    case "Cos":
                        function = Math.Cos;
                        break;
                    case "Tan":
                        function = Math.Tan;
                        break;
                    case "Asin":
                        function = Math.Asin;
                        break;
                    case "Acos":
                        function = Math.Acos;
                        break;
                    case "Atan":
                        function = Math.Atan;
                        break;
                    default:
                        return base.Invoke(name, args, at, ats);
                }
                return new Value(function((double)(args[0].Cast(Value.Type.Float).InnerValue)));
            }
            else if (args.Length == 2 && name == "Pow")
            {
                var x = (double)(args[0].Cast(Value.Type.Float).InnerValue);
                var y = (double)(args[1].Cast(Value.Type.Float).InnerValue);
                return new Value(Math.Pow(x, y));
            }
            return base.Invoke(name, args, at, ats);
        }
    }
}
