// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ArithmeticTermNode.cs 263 2010-01-16 13:12:35Z panacoran $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// Zp̃m[h\NXB
	/// </summary>
	public class ArithmeticTermNode : Node
	{
		/// <summary>
		/// m[h̃Xg
		/// </summary>
		private List<Node> nodeList;
		/// <summary>
		/// Z̎ނ\LN^̃Xg
		/// </summary>
		private List<char> opCharList;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
            Token = Scanner.Token;
            Node node = new PrefixedExpressionNode().Parse();
            string token = Scanner.Token.Value;
            if (!(token == "*" || token == "/" || token == "%"))
                return node;
            nodeList = new List<Node>();
            opCharList = new List<char>();
			nodeList.Add(node);
            do
            {
                opCharList.Add(token[0]);
                Scanner.Scan();
                nodeList.Add(new PrefixedExpressionNode().Parse());
                token = Scanner.Token.Value;
            }
            while (token == "*" || token == "/" || token == "%");
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			try
			{
				Value val1 = nodeList[0].Execute(resource, at);
				for(int i = 1; i < nodeList.Count; i++)
				{
                    Value val2 = nodeList[i].Execute(resource, at);
					switch (opCharList[i - 1])
                    {
                    case '*':
						val1 = val1 * val2;
                        break;
                    case '/':
						val1 = val1 / val2;
                        break;
                    default:
						val1 = val1 % val2;
                        break;
                    }
				}
				return val1;
			}
			catch(RuntimeException e)
			{
				if (e.Token == null)
					e.Token = Token;
				throw e;
			}		
		}
	}
}
