﻿// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2005 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Global.cs 321 2010-03-29 11:37:51Z panacoran $

using System;
using System.IO;
using System.Windows.Forms;
using Protra.Lib.Config;
using Protra.Lib.Data;

namespace Protra.Lib
{
	/// <summary>
	/// アプリケーション全体に使われる定数を提供するクラスです。
	/// </summary>
	public class Global
	{
		/// <summary>
		/// アプリケーションを開始したアセンブリの存在するディレクトリ
		/// </summary>
		public static readonly string DirApp = Path.GetDirectoryName(Application.ExecutablePath);
		/// <summary>
		/// データファイルを保存するディレクトリ
		/// </summary>
        public static readonly string DirData = Path.Combine(DirApp, "data");
        /// <summary>
        /// 株価データを保存するディレクトリ
        /// </summary>
        public static readonly string DirPrice = Path.Combine(DirData, "price");
        /// <summary>
        /// グローバル変数のデータを保存するディレクトリ
        /// </summary>
        public static readonly string DirGlobalData = Path.Combine(DirData, "global");
        /// <summary>/// 
        /// システムの実行履歴を保存するディレクトリ
        /// </summary>
        public static readonly string DirLog = Path.Combine(DirData, "log");
        /// <summary>
		/// 設定ファイルを保存するディレクトリ
		/// </summary>
		public static readonly string DirConf = Path.Combine(DirApp, "conf");
		/// <summary>
		/// ライブラリプログラムを保存するディレクトリ
		/// </summary>
		public static readonly string DirLib = Path.Combine(DirApp, "lib");
		/// <summary>
		/// チャートプログラムを保存するディレクトリ
		/// </summary>
		public static readonly string DirChart = Path.Combine(DirApp, "chart");
		/// <summary>
		/// システムプログラムを保存するディレクトリ
		/// </summary>
		public static readonly string DirSystem = Path.Combine(DirApp, "system");
		/// <summary>
		/// 一時的な作業のためのファイルなどを置くディレクトリ
		/// </summary>
		public static readonly string DirTmp = Path.Combine(DirApp, "tmp");
		/// <summary>
		/// マニュアルを置くディレクトリ
		/// </summary>
		public static readonly string DirMan = Path.Combine(DirApp, "man");
		/// <summary>
		/// アプリケーションを開始したアセンブリのパス
		/// </summary>
		public static readonly string PathApp = Application.ExecutablePath;
		/// <summary>
		/// マニュアルのファイルへのパス
		/// </summary>
		public static readonly string PathMan = Path.Combine(DirMan, "index.html");
	}

    /// <summary>
    /// アプリケーション全体で参照されるデータを提供するクラス。
    /// </summary>
    public class GlobalEnv
    {
        /// <summary>
        /// Protraの設定を取得または設定する。
        /// </summary>
        public static ProtraConfig ProtraConfig { set; get; }
        /// <summary>
        /// PtSimの設定を取得または設定する。
        /// </summary>
        public static PtSimConfig PtSimConfig { set; get; }
        /// <summary>
        /// 銘柄リストの設定を取得または設定する。
        /// </summary>
        public static BrandListConfig BrandListConfig { set; get; }
        /// <summary>
        /// データ更新に関する設定を取得または設定する。
        /// </summary>
        public static UpdateConfig UpdateConfig { set; get; }
        /// <summary>
        /// 銘柄データを取得または設定する。
        /// </summary>
        public static BrandData BrandData { set; get; }
    }
}
