﻿// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Token.cs 306 2010-03-19 13:21:22Z panacoran $

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 字句の型を表す列挙型。
    /// </summary>
    public enum TokenType
    {
        /// <summary>
        /// 整数
        /// </summary>
        Int,
        /// <summary>
        /// 浮動小数点
        /// </summary>
        Float,
        /// <summary>
        /// 文字列
        /// </summary>
        String,
        /// <summary>
        /// ローカル変数の名前
        /// </summary>
        LocalVariable,
        /// <summary>
        /// グローバル変数の名前
        /// </summary>
        GlobalVariable,
        /// <summary>
        /// 関数の名前
        /// </summary>
        FunctionName,
        /// <summary>
        /// 予約語
        /// </summary>
        Reserved,
        /// <summary>
        /// 型名
        /// </summary>
        Type,
        /// <summary>
        /// 演算子
        /// </summary>
        Operator,
        /// <summary>
        /// その他
        /// </summary>
        Unknown,
        /// <summary>
        /// ファイルの終端
        /// </summary>
        EOF,
    }

    /// <summary>
    /// 字句を表すクラス。
    /// </summary>
    public class Token
    {
        TokenType type;
        int lineno;
        string filename;
        string value;
        int intValue;
        double floatValue;
        Token next;

        /// <summary>
        /// 字句の型を取得または設定する。
        /// </summary>
        public TokenType Type
        {
            get { return type; }
            set { type = value; }
        }

        /// <summary>
        /// 行番号を取得または設定する。
        /// </summary>
        public int LineNo
        {
            get { return lineno; }
            set { lineno = value; }
        }

        /// <summary>
        /// ファイル名を取得または設定する。
        /// </summary>
        public string Filename
        {
            get { return filename; }
            set { filename = value; }
        }

        /// <summary>
        /// 字句を表す文字列を取得または設定する。
        /// </summary>
        public string Value
        {
            get { return value; }
            set { this.value = value; }
        }

        /// <summary>
        /// 字句の表す整数を取得または設定する。
        /// </summary>
        public int IntValue
        {
            get { return intValue; }
            set { intValue = value; }
        }

        /// <summary>
        /// 字句の表す浮動小数点を取得または設定する。
        /// </summary>
        public double FloatValue
        {
            get { return floatValue; }
            set { floatValue = value; }
        }

        /// <summary>
        /// 次の字句を取得または設定する。
        /// </summary>
        public Token Next
        {
            get { return next; }
            set { next = value; }
        }
    }
}
