// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Resource.cs 274 2010-02-28 11:21:56Z panacoran $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vOŝɕKvȃ\[XێNXB
	/// </summary>
	public class Resource
	{
        private Stack<Value[]> stack = new Stack<Value[]>();
        private Dictionary<FunctionType, FunctionDefinitionNode> ft = new Dictionary<FunctionType, FunctionDefinitionNode>();
        private Dictionary<string, Value> gvt = new Dictionary<string, Value>();
        private BasicBuiltins blt;

		/// <summary>
		/// X^bNt[擾B
		/// </summary>
        public Stack<Value[]> Stack
        {
            get { return stack; }
        }

		/// <summary>
		/// ֐̃e[u擾B
		/// </summary>
        public Dictionary<FunctionType, FunctionDefinitionNode> FunctionTable
        {
            get { return ft; }
        }

        /// <summary>
        /// O[oϐ̃e[u擾܂͐ݒ肷B
        /// </summary>
        public Dictionary<string, Value> GlobalVariableTable
        {
            get { return gvt; }
            set { gvt = value; }
        }

		/// <summary>
		/// gݍ݊֐̎擾܂͐ݒ肷B
		/// </summary>
        public BasicBuiltins Builtins
        {
            get { return blt; }
            set { blt = value; }
        }
	}
}
