// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008, 2010 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: Interpreter.cs 274 2010-02-28 11:21:56Z panacoran $

using System;
using System.Collections.Generic;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// vO̎sSNXB
	/// </summary>
	public class Interpreter
	{
		/// <summary>
		/// vÕm[h
		/// </summary>
		Node node = new ProgramNode();
		/// <summary>
		/// \[X
		/// </summary>
		private Resource resource;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// vO̍\͒ɃG[ꍇthrowB
		/// </exception>
		/// <param name="file">vOt@C̃pX</param>
		public Interpreter(string file)
		{
            Node.Scanner = new Scanner(file);
            // ֐̊Õ[Jϐ̋L\pӂB
            Node.LvtStack.Push(new Dictionary<string, int>());
			try
			{
				node = new ProgramNode();
                node.Parse();
			}
			catch(ParseException exc)
			{
                Token t = exc.Token;
                throw new ParseException(
                    "parse error in " + t.Filename + ":" + t.LineNo + ": " + exc.Message, null);
			}
            finally
            {
                Node.Scanner.Close();
            }
			resource = new Resource();
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <returns>vO̖߂lB</returns>
		public Value Execute()
		{
			resource.Stack.Clear();
			resource.FunctionTable.Clear();
			try
			{
				return node.Execute(resource, 0);
			}
			catch (RuntimeException e)
			{
                Token token = e.Token;
                throw new RuntimeException
                    ("runtime error in " + token.Filename + ":" + token.LineNo + ": " + e.Message, null);
			}
		}

		/// <summary>
		/// O[oϐ̃e[u擾܂͐ݒ肷B
		/// </summary>
		public Dictionary<string, Value> GlobalVariableTable
		{
			get { return resource.GlobalVariableTable; }
			set { resource.GlobalVariableTable = value; }
		}

        /// <summary>
        /// gݍ݊֐NX̃CX^X擾܂͐ݒ肷B
        /// </summary>
        public BasicBuiltins Builtins
        {
            get { return resource.Builtins; }
            set { resource.Builtins = value; }
        }
	}
}
