﻿// Copyright (C) 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ExpressionNode.cs 472 2013-06-26 15:26:49Z panacoran $

using System;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 代入式のノードを表すクラス。
    /// </summary>
    public class ExpressionNode
    {
        /// <summary>
        /// このノードの最初の字句を取得または設定する。
        /// </summary>
        public Token Token { get; set; }
        
        /// <summary>
        /// 構文解析する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.ParseException">
        /// 構文解析中にエラーが発生したときにthrowされる。
        /// </exception>
        public virtual ExpressionNode Parse(Scanner scanner)
        {
            return new AssignmentNode().Parse(scanner);
        }

        /// <summary>
        /// 式を評価する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.RuntimeException">
        /// 評価中にエラーが発生した場合にthrowされる。
        /// </exception>
        /// <param name="resource">リソース</param>
        /// <param name="at">int型@作用素の値</param>
        /// <param name="ats">string型@作用素の値</param>
        /// <returns>値</returns>
        public virtual Value Evaluate(Resource resource, int at, string ats)
        {
            throw new NotImplementedException();
        }
    }

}