﻿// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: RuntimeException.cs 455 2013-06-08 11:52:33Z panacoran $

using System;

namespace Protra.Lib.Lang
{
    /// <summary>
    /// プログラム実行中のエラー時にthrowされる例外です。
    /// </summary>
    public class RuntimeException : Exception
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="msg">メッセージ</param>
        /// <param name="token">エラーが発生した場所のトークン</param>
        /// <param name="e">原因になった例外</param>
        public RuntimeException(string msg, Token token, Exception e = null) : base(msg, e)
        {
            Token = token;
        }

        /// <summary>
        /// エラーが発生した場所のトークンを取得または設定する。
        /// </summary>
        public Token Token { get; set; }
    }
}