﻿// Copyright (C) 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id$

using System;
using System.Drawing;
using System.Windows.Forms;

namespace PtSim.Controls
{
    /// <summary>
    /// バーを直接描画するProgressBar
    /// VisualStyleのProgressBarは指定された値まで徐々にバーを進めるため、
    /// 値の増加が速いと描画が追い付かない。
    /// </summary>
    public class ProgressBarDirectRender : UserControl
    {
        private int _value;

        /// <summary>
        /// 値を取得または設定する。
        /// </summary>
        public int Value
        {
            get { return _value; }
            set
            {
                if (value < 0 || value > 100)
                    throw new ArgumentOutOfRangeException("value", "値の範囲は0～100です。");
                _value = value;
                if (!ProgressBarRenderer.IsSupported)
                    return;
                const int margin = 1;
                using (var g = CreateGraphics())
                {
                    if (_value == 0)
                        ProgressBarRenderer.DrawHorizontalBar(g, ClientRectangle);
                    else
                    {
                        var rectangle = new Rectangle(ClientRectangle.X + margin,
                                                      ClientRectangle.Y + margin,
                                                      ClientRectangle.Width * _value / 100 - margin * 2,
                                                      ClientRectangle.Height - margin * 2);
                        ProgressBarRenderer.DrawHorizontalChunks(g, rectangle);
                    }
                }
            }
        }

        /// <summary>
        /// ProgressBarを描画する。
        /// </summary>
        /// <param name="e">Paintイベントの引数</param>
        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);
            if (ProgressBarRenderer.IsSupported)
                ProgressBarRenderer.DrawHorizontalBar(e.Graphics, ClientRectangle);
        }
    }
}