﻿// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008, 2013 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ArrayNode.cs 455 2013-06-08 11:52:33Z panacoran $

namespace Protra.Lib.Lang
{
    /// <summary>
    /// 配列を生成するノードを表すクラス。
    /// </summary>
    public class ArrayNode : Node
    {
        /// <summary>
        /// 配列のサイズとなるノード
        /// </summary>
        private Node _node;

        /// <summary>
        /// 構文解析する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.ParseException">
        /// 構文解析中にエラーが発生したときにthrowされる。
        /// </exception>
        /// <return>
        /// 解析した結果のノード。
        /// </return>
        public override Node Parse()
        {
            Token = Scanner.Token;
            Scanner.Scan();
            _node = new ExpressionNode().Parse();
            if (Scanner.Token.Value != "]")
                throw new ParseException("']' expected", Scanner.Token);
            Scanner.Scan();
            return this;
        }

        /// <summary>
        /// プログラムを実行する。
        /// </summary>
        /// <exception cref="Protra.Lib.Lang.RuntimeException">
        /// プログラム実行中にエラーが発生した場合にthrowされる。
        /// </exception>
        /// <param name="resource">リソース</param>
        /// <param name="at">int型@作用素の値</param>
        /// <param name="ats">string型@作用素の値</param>
        /// <returns>実行結果</returns>
        public override Value Execute(Resource resource, int at, string ats)
        {
            var val = _node.Execute(resource, at, ats);
            if (val == null || val.ValueType != Value.Type.Int)
                throw new RuntimeException("invalid array size.", Token);
            return new Value(new Value[(int)val.InnerValue]);
        }
    }
}