// Copyright (C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// Copyright (C) 2008 panacoran <panacoran@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: ReturnStatementNode.cs 263 2010-01-16 13:12:35Z panacoran $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// returñm[h\NXB
	/// </summary>
	public class ReturnStatementNode : Node
	{
		/// <summary>
		/// ̃m[h
		/// </summary>
		private Node expNode;

		/// <summary>
		/// \͂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// \͒ɃG[ƂthrowB
		/// </exception>
        /// <return>
        /// ͂ʂ̃m[hB
        /// </return>
		public override Node Parse()
		{
			Token = Scanner.Token;
			if (!Scanner.Scan())
				throw new ParseException("';' expected", Scanner.Token);
			if (Scanner.Token.Value == ";")
                return this;
			expNode = new ExpressionNode().Parse();
			if (Scanner.Token.Value != ";")
				throw new ParseException("';' expected", Scanner.Token);
            return this;
		}

		/// <summary>
		/// vOsB
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrowB
		/// </exception>
		/// <exception cref="Protra.Lib.Lang.ReturnStatementExecutedException">
		/// ɖ߂lvZꂽꍇthrowB
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			Value val = null;
			if(expNode != null)
				val = expNode.Execute(resource, at);
			throw new ReturnStatementExecutedException(val);
		}
	}

	/// <summary>
	/// ReturnStatementNode.ExecuteĂ΂ꂽƂthrowOB
	/// </summary>
	public class ReturnStatementExecutedException : Exception
	{
		/// <summary>
		/// ߂ll
		/// </summary>
		private Value val;

		/// <summary>
		/// RXgN^
		/// </summary>
		/// <param name="val">߂ll</param>
		public ReturnStatementExecutedException(Value val)
		{
			this.val = val;
		}

		/// <summary>
		/// ߂ll擾B
		/// </summary>
		public Value Value
		{
			get { return val; }
		}
	}
}
